% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Analysis-class.R, R/RLum.Data-class.R, R/Risoe.BINfileData-class.R
\name{add_metadata<-}
\alias{add_metadata<-}
\alias{rename_metadata<-}
\alias{replace_metadata<-}
\alias{add_metadata<-,RLum.Analysis-method}
\alias{rename_metadata<-,RLum.Analysis-method}
\alias{replace_metadata<-,RLum.Analysis-method}
\alias{add_metadata<-,RLum.Data-method}
\alias{rename_metadata<-,RLum.Data-method}
\alias{replace_metadata<-,RLum.Data-method}
\alias{add_metadata<-,Risoe.BINfileData-method}
\alias{rename_metadata<-,Risoe.BINfileData-method}
\alias{replace_metadata<-,Risoe.BINfileData-method}
\title{Safe manipulation of object metadata}
\usage{
add_metadata(object, ...) <- value

rename_metadata(object, ...) <- value

replace_metadata(object, ...) <- value

\S4method{add_metadata}{RLum.Analysis}(object, info_element) <- value

\S4method{rename_metadata}{RLum.Analysis}(object, info_element) <- value

\S4method{replace_metadata}{RLum.Analysis}(object, info_element, subset = NULL) <- value

\S4method{add_metadata}{RLum.Data}(object, info_element) <- value

\S4method{rename_metadata}{RLum.Data}(object, info_element) <- value

\S4method{replace_metadata}{RLum.Data}(object, info_element, subset = NULL, verbose = TRUE) <- value

\S4method{add_metadata}{Risoe.BINfileData}(object, info_element) <- value

\S4method{rename_metadata}{Risoe.BINfileData}(object, info_element) <- value

\S4method{replace_metadata}{Risoe.BINfileData}(object, info_element, subset = NULL) <- value
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis}, \linkS4class{Risoe.BINfileData} (\strong{required}):
object of class \code{RLum.Analysis} or \code{Risoe.BINfileData} to manipulate.}

\item{...}{further arguments passed to the specific class method}

\item{value}{(\strong{required}):
value to be assigned to the selected metadata entry. A \code{NULL} value is
acceptable only for \code{replace_metadata}, in which case the elements named
in \code{info_element} will be removed.}

\item{info_element}{\link{character} (\strong{required}):
name of the metadata entry to manipulate.}

\item{subset}{\link{expression} (\emph{optional}):
logical expression to limit the substitution only to the selected subset
of elements.}

\item{verbose}{\link{logical} (\emph{with default}):
enable/disable output to the terminal.}
}
\description{
Generic functions for manipulation of metadata in \linkS4class{Risoe.BINfileData},
\linkS4class{RLum.Analysis} and \linkS4class{RLum.Data} objects.
}
\section{Functions}{
\itemize{
\item \code{add_metadata(RLum.Analysis) <- value}: Adds metadata to \linkS4class{RLum.Analysis} objects.

\item \code{rename_metadata(RLum.Analysis) <- value}: Renames a metadata entry of \linkS4class{RLum.Analysis} objects.

\item \code{replace_metadata(RLum.Analysis) <- value}: Replaces or removes metadata of \linkS4class{RLum.Analysis} objects.

\item \code{add_metadata(RLum.Data) <- value}: Add metadata entries to \linkS4class{RLum.Data} objects.

\item \code{rename_metadata(RLum.Data) <- value}: Rename a metadata entry of \linkS4class{RLum.Data} objects.

\item \code{replace_metadata(RLum.Data) <- value}: Replaces or removes metadata of \linkS4class{RLum.Data} objects.

\item \code{add_metadata(Risoe.BINfileData) <- value}: Adds metadata to \linkS4class{Risoe.BINfileData} objects.

\item \code{rename_metadata(Risoe.BINfileData) <- value}: Renames a metadata entry of \linkS4class{Risoe.BINfileData} objects.

\item \code{replace_metadata(Risoe.BINfileData) <- value}: Replaces or removes metadata of \linkS4class{Risoe.BINfileData} objects.

}}
\examples{

## load example data
data(ExampleData.BINfileData, envir = environment())

## show data
CWOSL.SAR.Data

## add a new field
add_metadata(CWOSL.SAR.Data,
             info_element = "INSTITUTE") <- "Heidelberg University"

## rename a field
rename_metadata(CWOSL.SAR.Data,
                info_element = "INSTITUTE") <- "INSTITUTION"

## replace all LTYPE to RSL
## but only for the first position
replace_metadata(
 object = CWOSL.SAR.Data,
 info_element = "LTYPE",
 subset = (POSITION == 1)) <- "RSL"

## replacing a field with NULL allows to remove that field
replace_metadata(CWOSL.SAR.Data,
                 info_element = "PREVIOUS") <- NULL

## show the modified data
CWOSL.SAR.Data

}
\seealso{
\linkS4class{RLum.Data}, \linkS4class{RLum.Analysis}, \linkS4class{Risoe.BINfileData}
}
\author{
Marco Colombo, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Colombo, M., 2025. add_metadata<-(): Safe manipulation of object metadata. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
