% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Analysis-class.R
\name{structure_RLum}
\alias{structure_RLum}
\alias{structure_RLum,list-method}
\alias{structure_RLum,RLum.Analysis-method}
\title{General structure function for RLum-class objects}
\usage{
structure_RLum(object, ...)

\S4method{structure_RLum}{list}(object, ...)

\S4method{structure_RLum}{RLum.Analysis}(object, fullExtent = FALSE)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}}

\item{...}{further arguments passed to the specific class method}

\item{fullExtent}{\link{logical} (\emph{with default}):
extends the returned \code{data.frame} to its full extent, i.e. all info elements
are part of the return as well. The default value is \code{FALSE} as the data
frame might become rather big.}
}
\value{
Returns a \link{data.frame} with structure of the object.
}
\description{
The function provides a generalised access point for specific
\linkS4class{RLum} objects. Depending on the input object, the corresponding
function will be selected.
}
\section{Functions}{
\itemize{
\item \code{structure_RLum(list)}: Returns a list of data frames containing the structure of each \linkS4class{RLum}
object in the input list.

\item \code{structure_RLum(RLum.Analysis)}: Returns the structure of an \linkS4class{RLum.Analysis} object.

}}
\section{Function version}{
 0.2.0
}

\examples{

## load example data
data(ExampleData.XSYG, envir = environment())

## show structure
structure_RLum(OSL.SARMeasurement$Sequence.Object)

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. structure_RLum(): General structure function for RLum-class objects. Function version 0.2.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
