% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.wcls.R
\name{summary.wcls_fit}
\alias{summary.wcls_fit}
\title{Summarize Causal Excursion Effect Fits for MRT with Continuous Outcomes}
\usage{
\method{summary}{wcls_fit}(
  object,
  lincomb = NULL,
  conf_level = 0.95,
  show_control_fit = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class "wcls_fit".}

\item{lincomb}{A vector of length p (p is the number of moderators including
intercept) or a matrix with p columns. When not set to `NULL`,
the summary will include the specified linear combinations of the causal excursion
effect coefficients and the corresponding confidence interval, standard error,
and p-value.}

\item{conf_level}{A numeric value indicating the confidence level for
confidence intervals. Default to 0.95.}

\item{show_control_fit}{A logical value of whether the fitted coefficients
for the control variables will be printed in the summary. Default to FALSE.
(Interpreting the fitted coefficients for control variables is not recommended.)}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
the original function call and the estimated causal excursion effect
coefficients, 95% confidence interval, Standard Error, Hotelling's T-statistic
value or Wald-statistic value (depending on whether sample size is < 50),
degrees of freedom, and p-value.
}
\description{
\code{summary} method for class "wcls_fit".
}
\examples{
fit <- wcls(
    data = data_mimicHeartSteps,
    id = "userid",
    outcome = "logstep_30min",
    treatment = "intervention",
    rand_prob = 0.6,
    moderator_formula = ~1,
    control_formula = ~logstep_pre30min,
    availability = "avail",
    numerator_prob = 0.6
)
summary(fit)
}
