% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsroc.plot.R
\name{hsroc.plot}
\alias{hsroc.plot}
\title{Plotting Results from \code{nmadt.hsroc} and \code{nmadt.hsroc.MNAR}}
\usage{
hsroc.plot(
  nstu,
  K,
  data,
  testname,
  output,
  directory,
  typeofplot = c("density", "forest", "sroc", "contour"),
  n.chains = 3
)
}
\arguments{
\item{nstu}{an integer indicating the number of studies included in the dataset.}

\item{K}{an integer indicating the number of candiate test in the dataset.}

\item{data}{a list conating the input dataset to be used for meta-analysis.}

\item{testname}{a string vector of the names of the candidate tests in the dataset in the same order as presetned in the dataset.}

\item{output}{a list object obtained by function \code{nmadt.hsroc} or \code{nmadt.hsroc.MNAR}.}

\item{directory}{a string specifying the designated directory to save the plots.}

\item{typeofplot}{a string vector containing the types of plot to be generated including "density", "forest","sroc", and "contour".}

\item{n.chains}{a number indicating number of MCMC chains generated using \code{nmadt.hsroc} or \code{nmadt.hsroc.MNAR}. The default is 3.}
}
\value{
No return value, called for side effects (generating and saving plots).
}
\description{
\code{hsroc.plot} plots the results from \code{nmadt.hsroc} and \code{nmadt.hsroc.MNAR}.Graphics representation includes density plots, forest plots, SROC curves, and contour plots of the results.
}
\examples{
\donttest{
kangdata<-read.csv(file=system.file("extdata","kangdata.csv",package="NMADTA"),
header=TRUE, sep=",")
set.seed(9)
kang.out.hsroc <- nmadt.hsroc(nstu=12, K=2, data=kangdata, testname=c("D-dimer","Ultrasonography"))
hsroc.plot(nstu=12, K=2, data=kangdata, directory = tempdir(),
testname=c("D-dimer","Ultrasonography"),output=kang.out.hsroc)
}
}
