% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_scaling.R
\name{nmar_scaling_infra}
\alias{nmar_scaling_infra}
\title{Shared scaling infrastructure for NMAR engines}
\description{
Centralized feature scaling and parameter unscaling routines used by NMAR
estimation engines to ensure consistent, numerically stable behavior.
}
\section{Goals}{

\itemize{
  \item Provide an engine-agnostic API for standardizing design matrices and
    auxiliary moments before solving.
  \item Return a minimal scaling recipe (\code{nmar_scaling_recipe}) used to
    unscale coefficients and covariance matrices after solving.
}
}

\section{Inputs/Outputs}{

\describe{
  \item{Inputs}{\code{Z_un} (response model matrix with intercept),
    optional \code{X_un} (auxiliary model matrix, no intercept),
    optional named \code{mu_x_un} (auxiliary means on the original scale),
    and a logical \code{standardize} flag.}
  \item{Outputs}{Scaled matrices \code{Z}, \code{X}, and \code{mu_x}, plus an
    \code{nmar_scaling_recipe} used later for unscaling.}
}
}

\section{Integration pattern}{

\enumerate{
  \item Before solving: call \code{validate_and_apply_nmar_scaling()} (engine-level)
        or \code{prepare_nmar_scaling()} (low-level) to obtain scaled matrices
        and recipe.
  \item Solve in the scaled space.
  \item After solving: call \code{unscale_coefficients()} to unscale coefficients
        and their covariance matrices.
  \item Store the \code{nmar_scaling_recipe} in results for diagnostics and reproducibility.
}
}

\section{Notes}{

\itemize{
  \item The intercept column is never scaled.
  \item Columns with near-zero variance are centered but assigned
    \code{sd = 1} so that the corresponding parameter is not inflated by
    division by a very small standard deviation.
  \item Engines may use design-weighted scaling via the \code{weights} and
        \code{weight_mask} arguments.
}
}

\keyword{internal}
