% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generate.R
\name{generateFullReport}
\alias{generateFullReport}
\title{generateFullReport}
\usage{
generateFullReport(
  server,
  username,
  password,
  dbms,
  resultsSchema = NULL,
  targetId = 1,
  outcomeIds = 3,
  comparatorIds = 2,
  indicationIds = "",
  cohortNames = c("target name", "outcome name", "comp name"),
  cohortIds = c(1, 3, 2),
  includeCI = TRUE,
  includeCharacterization = TRUE,
  includeCohortMethod = TRUE,
  includeSccs = TRUE,
  includePrediction = TRUE,
  webAPI = NULL,
  authMethod = NULL,
  webApiUsername = NULL,
  webApiPassword = NULL,
  outputLocation,
  outputName = paste0("full_report_", gsub(":", "_", gsub(" ", "_",
    as.character(date()))), ".html"),
  intermediateDir = tempdir(),
  pathToDriver = Sys.getenv("DATABASECONNECTOR_JAR_FOLDER")
)
}
\arguments{
\item{server}{The server containing the result database}

\item{username}{The username for an account that can access the result database}

\item{password}{The password for an account that can access the result database}

\item{dbms}{The dbms used to access the result database}

\item{resultsSchema}{The result database schema}

\item{targetId}{The cohort definition id for the target cohort}

\item{outcomeIds}{The cohort definition id for the outcome}

\item{comparatorIds}{The cohort definition id for any comparator cohorts}

\item{indicationIds}{The cohort definition id for any indication cohorts (if no indication use '')}

\item{cohortNames}{Friendly names for any cohort used in the study}

\item{cohortIds}{The corresponding Ids for the cohortNames}

\item{includeCI}{Whether to include the cohort incidence slides}

\item{includeCharacterization}{Whether to include the characterization slides}

\item{includeCohortMethod}{Whether to include the cohort method slides}

\item{includeSccs}{Whether to include the self controlled case series slides}

\item{includePrediction}{Whether to include the patient level prediction slides}

\item{webAPI}{The ATLAS web API to use for the characterization index breakdown (set to NULL to not include)}

\item{authMethod}{The authorization method for the webAPI}

\item{webApiUsername}{The username for the webAPI authorization}

\item{webApiPassword}{The password for the webAPI authorization}

\item{outputLocation}{The file location and name to save the protocol}

\item{outputName}{The name of the html protocol that is created}

\item{intermediateDir}{The work directory for quarto}

\item{pathToDriver}{Path to a folder containing the JDBC driver JAR files.}
}
\value{
An html document containing the full results for the target, comparators, indications and outcomes specified.
}
\description{
Generates a full report from a Strategus analysis
}
\details{
Specify the connection details to the result database and the schema name
to generate the full report.
}
\seealso{
Other Reporting: 
\code{\link{generatePresentation}()},
\code{\link{generatePresentationMultiple}()}
}
\concept{Reporting}
