% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obwoe.R
\name{plot.obwoe}
\alias{plot.obwoe}
\title{Plot Method for obwoe Objects}
\usage{
\method{plot}{obwoe}(
  x,
  type = c("iv", "woe", "bins"),
  feature = NULL,
  top_n = 15,
  show_threshold = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{"obwoe"}.}

\item{type}{Character string specifying the plot type:
\describe{
  \item{\code{"iv"}}{Information Value ranking bar chart (default)}
  \item{\code{"woe"}}{Weight of Evidence profile for selected features}
  \item{\code{"bins"}}{Bin distribution (count and event rate)}
}}

\item{feature}{Character vector of feature names to plot (for \code{"woe"}
and \code{"bins"} types). If \code{NULL}, uses top 6 features by IV.}

\item{top_n}{Integer. For \code{"iv"} type, number of top features to display.
Default is 15. Set to \code{NULL} to display all.}

\item{show_threshold}{Logical. For \code{"iv"} type, draw horizontal lines
at IV thresholds (0.02, 0.10, 0.30)? Default is \code{TRUE}.}

\item{...}{Additional arguments passed to base plotting functions.}
}
\value{
Invisibly returns \code{NULL}. Called for side effect (plotting).
}
\description{
Creates publication-quality visualizations of optimal binning results.
Supports multiple plot types including IV ranking charts, WoE profiles,
and bin distribution plots. All plots follow credit scoring visualization
conventions.
}
\details{
\subsection{Plot Types}{

\strong{IV Ranking (\code{type = "iv"})}:
Horizontal bar chart showing features ranked by Information Value.
Colors indicate predictive power classification:
\itemize{
  \item Gray: IV < 0.02 (Unpredictive)
  \item Yellow: 0.02 <= IV < 0.10 (Weak)
  \item Orange: 0.10 <= IV < 0.30 (Medium)
  \item Green: 0.30 <= IV < 0.50 (Strong)
  \item Red: IV >= 0.50 (Suspicious)
}

\strong{WoE Profile (\code{type = "woe"})}:
Bar chart showing Weight of Evidence values for each bin.
Positive WoE indicates higher-than-average event rate;
negative WoE indicates lower-than-average event rate.
Monotonic WoE patterns are generally preferred for interpretability.

\strong{Bin Distribution (\code{type = "bins"})}:
Dual-axis plot showing observation counts (bars) and event rates (line).
Useful for diagnosing bin quality and class imbalance.
}
}
\examples{
\donttest{
set.seed(42)
df <- data.frame(
  age = rnorm(500, 40, 15),
  income = rgamma(500, 2, 0.0001),
  score = rnorm(500, 600, 100),
  target = rbinom(500, 1, 0.2)
)
result <- obwoe(df, target = "target")

# IV ranking chart
plot(result, type = "iv")

# WoE profile for specific feature
plot(result, type = "woe", feature = "age")

# Bin distribution
plot(result, type = "bins", feature = "income")
}

}
\references{
Thomas, L. C., Edelman, D. B., & Crook, J. N. (2002). Credit Scoring
and Its Applications. \emph{SIAM Monographs on Mathematical Modeling
and Computation}. \doi{10.1137/1.9780898718317}
}
\seealso{
\code{\link{obwoe}}, \code{\link{summary.obwoe}}.
}
