% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_risk_score.R
\name{get_risk_score}
\alias{get_risk_score}
\title{Calculates the risk score for patients}
\usage{
get_risk_score(
  final_signature,
  pfs_score,
  path_Ucox_mul_res,
  sur,
  TRAIN = TRUE
)
}
\arguments{
\item{final_signature}{Cancer-specific dysregulated signal pathways. It can be generated by the function `get_final_signature`.}

\item{pfs_score}{A matrix that contains the pfs_score in each sample of the signal pathways. Noted the matrix can be generated by the function `get_pfs_score`.}

\item{path_Ucox_mul_res}{Results of multivariate Cox regression of cancer specific pathway in training set.}

\item{sur}{This data contains survival status and survival time of each sample.}

\item{TRAIN}{Logical,if set FLASE,we need to load the result of multivariate Cox regression of cancer specific pathways into the training set.}
}
\value{
A data set with the risk score for each sample.
}
\description{
The function `get_risk_score` uses to calculate the risk score for patients based on cancer-specific dysregulated signaling pathways.
}
\examples{
#Load the data.
data(final_signature,pfs_score,sur,path_Ucox_mul_res)
#perform the function `get_risk_score`.
km_data<-get_risk_score(final_signature,pfs_score,path_Ucox_mul_res,sur,TRAIN=TRUE)
}
