% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A00-surveff.R
\name{summary.surveff}
\alias{summary.surveff}
\title{Summary Method for surveff Objects}
\usage{
\method{summary}{surveff}(
  object,
  conf_level = 0.95,
  max.len = 6,
  round.digits = 4,
  style = "prints",
  ...
)
}
\arguments{
\item{object}{A \code{surveff} object.}

\item{conf_level}{Confidence level for intervals. Default 0.95.}

\item{max.len}{Maximum number of rows (time points) to print. Default 6.
Only used if \code{style = "prints"}.}

\item{round.digits}{Number of digits for rounding displayed values. Default 4.
Only used if \code{style = "prints"}.}

\item{style}{Output style: "prints" (print formatted tables) or "returns"
(return list of matrices). Default "prints".}

\item{...}{Additional arguments (ignored).}
}
\value{
If \code{style = "prints"}, returns invisibly. If \code{style = "returns"},
  returns a list with:
  \item{survival_summary}{List of matrices, one per treatment group, with columns:
    Time, Estimate, SE, CI.lower, CI.upper}
  \item{difference_summary}{List of matrices, one per contrast, with same columns.
    NULL if no contrasts estimated.}
}
\description{
Summary Method for surveff Objects
}
