% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CyclopsSettings.R
\name{setLassoLogisticRegression}
\alias{setLassoLogisticRegression}
\title{Create modelSettings for lasso logistic regression}
\usage{
setLassoLogisticRegression(
  variance = 0.01,
  seed = NULL,
  includeCovariateIds = c(),
  noShrinkage = c(0),
  threads = -1,
  forceIntercept = FALSE,
  upperLimit = 20,
  lowerLimit = 0.01,
  tolerance = 2e-06,
  maxIterations = 3000,
  priorCoefs = NULL
)
}
\arguments{
\item{variance}{Numeric: prior distribution starting variance}

\item{seed}{An option to add a seed when training the model}

\item{includeCovariateIds}{a set of covariateIds to limit the analysis to}

\item{noShrinkage}{a set of covariates whcih are to be forced to be included in
in the final model. Default is the intercept}

\item{threads}{An option to set number of threads when training model.}

\item{forceIntercept}{Logical: Force intercept coefficient into prior}

\item{upperLimit}{Numeric: Upper prior variance limit for grid-search}

\item{lowerLimit}{Numeric: Lower prior variance limit for grid-search}

\item{tolerance}{Numeric: maximum relative change in convergence criterion from
from successive iterations to achieve convergence}

\item{maxIterations}{Integer: maximum iterations of Cyclops to attempt
before returning a failed-to-converge error}

\item{priorCoefs}{Use coefficients from a previous model as starting
points for model fit (transfer learning)}
}
\value{
\code{modelSettings} object
}
\description{
Create modelSettings for lasso logistic regression
}
\examples{
modelLasso <- setLassoLogisticRegression(seed=42)
}
