% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_candidate_module}
\alias{get_candidate_module}
\title{Get candidate module.}
\usage{
get_candidate_module(
  local_network,
  network,
  freq_matrix,
  sur,
  seed,
  max.size,
  rate
)
}
\arguments{
\item{local_network}{The local networks,generated by `get_local_network`.}

\item{network}{The maximum connected subnet,extracted by mapping all mutated genes to the PPI network.}

\item{freq_matrix}{The mutations matrix,generated by `get_mut_status`.}

\item{sur}{A nx2 data frame of samples' survival data,the first line is samples' survival event and the second line is samples' overall survival.}

\item{seed}{The canonical drivers from NCG database, which use as the starting node of the greedy algorithm.}

\item{max.size}{The maximum size of the module,default is 200.}

\item{rate}{The rate of increase in score,default is 0.05.}
}
\value{
candidate module.
}
\description{
The function `get_candidate_module` is used to search candidate module of each local network using greedy algorithm.
}
\examples{
\donttest{#load the data
data(local_network)
data(mut_status)
data(subnet)
canonical_drivers<-system.file("extdata","canonical_drivers.txt",package = "ProgModule")
seed_gene<-read.table(canonical_drivers,header=FALSE)
sur<-system.file("extdata","sur.csv",package = "ProgModule")
sur<-read.delim(sur,sep=",",header=TRUE,row.names=1)
#perform the function `get_candidate_module`.
candidatemodule.example<-get_candidate_module(local_network=local_network,network=subnet,
freq_matrix=mut_status,sur=sur,seed=seed_gene[,1],max.size=200,rate=0.05)}
}
