% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_velocity.R
\name{test_velocity}
\alias{test_velocity}
\title{Test for differences in velocity means with pairwise comparisons}
\usage{
test_velocity(data, trackvel, plot = FALSE, analysis = NULL)
}
\arguments{
\item{data}{A \code{track} R object, which is a list consisting of two elements:
\itemize{
\item \strong{\code{Trajectories}}: A list of interpolated trajectories, where each trajectory is a series of midpoints between consecutive footprints.
\item \strong{\code{Footprints}}: A list of data frames containing footprint coordinates, metadata (e.g., image reference, ID), and a marker indicating whether the footprint is actual or inferred.
}}

\item{trackvel}{A \code{track velocity} R object consisting of a list where each element corresponds to a track and contains velocity or relative stride length data.}

\item{plot}{A logical value indicating whether to plot a boxplot of velocities by track (default is \code{FALSE}).}

\item{analysis}{A character string specifying the type of analysis: \code{"ANOVA"}, \code{"Kruskal-Wallis"}, or \code{"GLM"}. Default is \code{"ANOVA"}.}
}
\value{
A list with the results of the statistical analysis and diagnostic tests:
\itemize{
\item \code{normality_results}: A matrix of test statistics and \emph{p}-values from the Shapiro-Wilk test for each track, with rows for the test statistic and \emph{p}-value, and columns for each track.
\item \code{homogeneity_test}: The result of Levene's test, including the \emph{p}-value for homogeneity of variances.
\item \code{ANOVA} (If \code{analysis} is \code{"ANOVA"}): A list containing the ANOVA table and Tukey HSD post-hoc test results.
\item \code{Kruskal_Wallis} (If \code{analysis} is \code{"Kruskal-Wallis"}): A list containing the Kruskal-Wallis test result and Dunn's test post-hoc results.
\item \code{GLM} (If \code{analysis} is \code{"GLM"}): A summary of the GLM fit and pairwise comparisons.
\item \code{plot} (If \code{plot} is \code{TRUE}): A boxplot of velocities by track is generated and displayed.
}
}
\description{
\code{test_velocity()} evaluates differences in velocity means across different tracks using a specified statistical test. It includes options for ANOVA, Kruskal-Wallis test, and Generalized Linear Models (GLM), and checks for assumptions such as normality and homogeneity of variances. For datasets with more than two tracks, it performs pairwise comparisons to identify specific differences between tracks.
}
\details{
The \code{test_velocity} function performs the following operations:
\itemize{
\item \strong{Condition Testing:}
\itemize{
\item \strong{Normality:} Shapiro-Wilk test for normality on velocity data within each track.
\item \strong{Homogeneity of Variances:} Levene's test for equal variances across tracks.
}
\item \strong{Statistical Analysis:}
\itemize{
\item \strong{ANOVA:} Compares mean velocities across tracks, assuming normality and homogeneity of variances. Includes Tukey's HSD post-hoc test for pairwise comparisons.
\item \strong{Kruskal-Wallis Test:} Non-parametric alternative to ANOVA for comparing median velocities across tracks when assumptions are violated. Includes Dunn's test for pairwise comparisons.
\item \strong{GLM:} Generalized Linear Model with a Gaussian family for comparing means if ANOVA assumptions are not met. Pairwise comparisons in the GLM are conducted using estimated marginal means (least-squares means) with the \pkg{emmeans} package, which computes differences between group means while adjusting for multiple comparisons using Tukey’s method.
}
\item \strong{Plotting:}
\itemize{
\item If \code{plot} is \code{TRUE}, a boxplot of velocities by track is generated.
}
}
}
\section{Logo}{

\if{html}{\figure{Logo.png}{options: width=30\%}}
}

\examples{
# Example 1: Test for Differences in Velocity Means with Pairwise Comparisons in Trajectories
# in MountTom dataset.

# Hip heights for each track in the MountTom dataset
H_mounttom <- c(
  1.380, 1.404, 1.320, 1.736, 1.364, 1.432, 1.508, 1.768, 1.600, 1.848,
  1.532, 1.532, 0.760, 1.532, 1.688, 1.620, 0.636, 1.784, 1.676, 1.872,
  1.648, 1.760, 1.612
)

# Calculate velocities using the default Method "A"
V_mounttom <- velocity_track(MountTom, H = H_mounttom)

# Test for Differences in Velocity Means with Pairwise Comparisons
test_velocity(MountTom, V_mounttom)

# Example 2: Test for Differences in Velocity Means with Pairwise Comparisons in Trajectories
# in PaluxyRiver dataset.

# Hip heights for each track in the PaluxyRiver dataset
H_paluxyriver <- c(3.472, 2.200)

# Specify different methods for different tracks
Method_paluxyriver <- c("A", "B")

# Calculate velocities using specified methods
V_paluxyriver <- velocity_track(PaluxyRiver, H = H_paluxyriver, method = Method_paluxyriver)

# Test for Differences in Velocity Means with Pairwise Comparisons
test_velocity(PaluxyRiver, V_paluxyriver)

}
\seealso{
\code{\link{tps_to_track}}, \code{\link{velocity_track}}
}
\author{
Humberto G. Ferrón

humberto.ferron@uv.es

Macroevolution and Functional Morphology Research Group (www.macrofun.es)

Cavanilles Institute of Biodiversity and Evolutionary Biology

Calle Catedrático José Beltrán Martínez, nº 2

46980 Paterna - Valencia - Spain

Phone: +34 (9635) 44477
}
