% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REDCapDM-package.R
\name{REDCapDM-package}
\alias{REDCapDM-package}
\alias{REDCapDM}
\title{Managing REDCap Data: The R package REDCapDM / REDCapDM: A Toolkit for Managing REDCap Data in R}
\description{
The \strong{REDCapDM} package provides tools to import, process, and manage REDCap data within R.
It supports data retrieval through the REDCap API or directly from exported files and includes a robust
set of functions for data transformation, validation, and discrepancy management. Designed for efficient
workflow integration, \strong{REDCapDM} simplifies the handling of REDCap datasets, making it easier to ensure
data quality and consistency.

Key Features:
\itemize{
\item \strong{Flexible Data Import}: Import data directly from REDCap using API connections or process exported REDCap files.
\item \strong{Data Transformation}: Streamline the cleaning and preparation of raw datasets for analysis.
\item \strong{Query Management}: Identify and track data discrepancies, missing events, and manage resolution reports.
}

Core Functions:
\itemize{
\item \code{redcap_data}: Reads data exported from REDCap or retrieved through the REDCap API into R.
\item \code{rd_transform}: One-step pipeline to clean and preprocess the raw REDCap data.
\itemize{
\item \code{rd_dates}: Standardize date and datetime fields.
\item \code{rd_delete_vars}: Remove specified variables (by name or pattern).
\item \code{rd_recalculate}: Recompute calculated fields and compare with REDCap values.
\item \code{rd_factor}: Replace numeric multiple-choice columns with their factor version.
\item \code{rd_checkbox}: Expand checkbox responses with custom labels and rename 'var___1' columns (REDCap style) to 'var_option'.
\item \code{rd_split}: Splits a REDCap dataset by form or event.
\item \code{rd_insert_na}: Manually set specified variables to missing based on a logical filter.
\item \code{rd_rlogic}: Translate REDCap branching or calculation logic into R syntax.
\item \code{rd_dictionary}: Update dictionary (translation of REDCap logic into R syntax) to reflect transformed data and logic.
}
\item \code{rd_query}: Identifies discrepancies (queries) in the dataset for validation.
\item \code{rd_event}: Detects missing events in longitudinal datasets.
\item \code{check_queries}: Compares historical and current query reports to track changes and additions.
\item \code{rd_export}: Exports a summary report of identified queries to an Excel (.xlsx) file.
}
}
\examples{
\dontrun{
# Install REDCapDM from CRAN:
install.packages("REDCapDM")

# Install the latest version of REDCapDM from GitHub:
remotes::install_github("bruigtp/REDCapDM")
}

}
\keyword{internal}
