% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.mark.binary.R
\name{readMarkVcv}
\alias{readMarkVcv}
\alias{read.mark.binary}
\title{Reads binary file output from MARK and returns a list of the results}
\usage{
readMarkVcv(f = "mark001.vcv", derived_labels)
}
\arguments{
\item{f}{filename specification for binary output file from MARK;named here as markxxx.vcv}

\item{derived_labels}{vector of labels for derived parameters; NULL if no derived parameters for model}
}
\value{
List of estimates, se, lcl, ucl and var-cov matrices for beta, real
and derived estimates \item{beta}{Dataframe for beta parameters containing
estimates, se, lcl, ucl} \item{beta.vcv}{variance-covariance matrix for beta
estimates} \item{real}{Dataframe for real parameters containing estimates,
se, lcl, ucl} \item{real.vcv}{variance-covariance matrix for real estimates}
\item{derived}{list of Dataframes for derived parameters (if any) containing
estimates, se, lcl, ucl} \item{derived.vcv}{variance-covariance matrix for
derived estimates (if any)}
}
\description{
Window and linux versions to read binary files created by MARK. This function written
by Jim Hines and modified by Jeff Laake to add derived_labels, replaces read.mark.binary
and read.mark.binary.linux
}
\examples{
\donttest{
#a=readMarkVcv('~/../Downloads/mark005.vcv')
#str(a)
}
}
\seealso{
\code{\link{extract.mark.output}}
}
\author{
Jim Hines, Jeff Laake
}
\keyword{utility}
