% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotShift.R
\name{plotShift}
\alias{plotShift}
\alias{addShift}
\title{Graphical representation of search.shift results}
\usage{
plotShift(RR,SS,mode,state=NULL)

addShift(SS,symbols.args=NULL)
}
\arguments{
\item{RR}{the object produced by \code{\link{RRphylo}} used to perform
\code{\link{search.shift}}.}

\item{SS}{an object produced by \code{\link{search.shift}}.}

\item{mode}{if \code{\link{search.shift}} was performed under \code{status.type =
"clade"} by setting the \code{node} argument, \code{mode} is a numeric
indicating whether the output number 1, that is
\code{...$single.clades$singles} or the output number 2
\code{...$single.clades$no.others} should be plotted.}

\item{state}{if \code{\link{search.shift}} was performed under \code{status.type =
"sparse"}, this is the same \code{state} vector provided to the function.}

\item{symbols.args}{as described for \code{$plotClades} below.}
}
\value{
The function returns a function to generate a customizable plot of
 \code{\link{search.shift}} results.

If \code{\link{search.shift}} was performed under \code{status.type =
 "clade"}, \code{plotShift} returns a \strong{\code{$plotClades}} function
 which highlights the shifting clades onto the phylogenetic tree. The usage
 is:
 \code{...$plotClades(tree.args=NULL,symbols.args=NULL)}, where
 \code{tree.args} is a list of further arguments passed to the function
 \code{plot.phylo}, and \code{symbols.args} is a list of further arguments
 passed to the function \code{symbols} (n.b. the shape of the symbol is not
 customizable). The function automatically plots red circles for negative
 shifts and blue circles for positive shifts, in each cases with the radium
 proportional to the absolute value of rate difference. The user can choose
 different color options for positive/negative shifts by setting
 \code{symbols.args=list(fg=c(pos="color for positive shift",neg="color for
 negative shift"))}, or provide a vector of as many colors as the number of
 shifting clades. The same applies to the argument "bg".

If \code{\link{search.shift}} was performed under \code{status.type =
 "sparse"}, \code{plotShift} returns a \strong{\code{$plotStates}} function
 which plots the comparison between the real difference and the distributions
 of random differences (see
 \href{../doc/search.shift.html}{\code{search.shift} vignette#sparse}). The
 usage is:
 \code{...$plotStates(plot.args=NULL,points.args=NULL,legend.args=list())},
 where \code{plot.args} is a list of further arguments passed to the function
 \code{plot} (used in the form: \code{plot(y~x)}), \code{points.args} is a
 list of further arguments passed to the function \code{points}, and
 \code{legend.args} is a list of additional arguments passed to the function
 \code{legend} (if \code{= NULL} the legend is not plotted). If as many
 colors/pch values as the number of different states are provided in
 \code{points.args}, each of them is assigned to each states taken in the
 same alphabetical order.
}
\description{
\code{plotShift} generates customized functions to produce plots
 out of \code{\link{search.shift}} results. \code{addShift} adds circles to
 highlight shifting clades onto the currently plotted tree.
}
\details{
Using \code{...$plotClades()} or plotting the tree and applying
 \code{addShift()} returns the same plot. The latter function might be useful
 in combination with \code{\link{plotRR}} to add the shifts information to
 the branch-wise plot of evolutionary rate values.
}
\examples{
\dontrun{
data("DataOrnithodirans")
DataOrnithodirans$treedino->treedino
DataOrnithodirans$massdino->massdino
DataOrnithodirans$statedino->statedino
cc<- 2/parallel::detectCores()

RRphylo(tree=treedino,y=massdino,clus=cc)->dinoRates

search.shift(RR=dinoRates,status.type="clade")->SSauto
plotShift(RR=dinoRates,SS=SSauto)->plotSSauto
plotSSauto$plotClades()

plot(dinoRates$tree)
addShift(SS=SSauto)

search.shift(RR=dinoRates,status.type="clade",node=c(696,746))->SSnode
plotShift(RR=dinoRates,SS=SSnode,mode=2)->plotSSnode
plotSSnode$plotClades(tree.args=list(no.margin=TRUE),
                  symbols.args=list(fg=NA,bg=c(pos="cyan",neg="magenta")))


search.shift(RR=dinoRates,status.type= "sparse",state=statedino)->SSstate
plotShift(RR=dinoRates,SS=SSstate,state=statedino)->plotSSstate
plotSSstate$plotStates(points.args=list(bg=c("gold","forestgreen","royalblue","white"),
                                   col=c("black","black","black","orangered"),
                                   pch=c(21,22,24,11)),legend.args=list())
    }
}
\references{
Castiglione, S., Tesone, G., Piccolo, M., Melchionna, M.,
 Mondanaro, A., Serio, C., Di Febbraro, M., & Raia, P.(2018). A new method
 for testing evolutionary rate variation and shifts in phenotypic evolution.
 \emph{Methods in Ecology and Evolution}, 9:
 974-983.doi:10.1111/2041-210X.12954
}
\seealso{
\href{../doc/search.shift.html}{\code{search.shift} vignette}

\href{../doc/Plotting-tools.html#plotShift}{\code{plotShift} vignette}
}
\author{
Silvia Castiglione, Giorgia Girardi
}
