% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_load_samples.R
\name{load_samples}
\alias{load_samples}
\title{Load MCMC samples}
\usage{
load_samples(RSTr_obj, param = "lambda", burn = 2000)
}
\arguments{
\item{RSTr_obj}{\code{RSTr} model object to load in samples from.}

\item{param}{Which parameter samples to load.}

\item{burn}{Number of burn-in samples to discard.}
}
\value{
An \code{array} of samples from model \code{RSTr_obj}.
}
\description{
\code{load_samples()} gathers samples saved for model \code{RSTr_obj}. By default, loads the rate estimate samples \code{lambda}, but any model parameters can be loaded. Users can also specify a burn-in period.
}
\examples{
data_min <- lapply(miheart, \(x) x[1:2, 1:3, 1:3])
adj_min <- list(2, 1)
mod_mst <- mstcar("test", data_min, adj_min, tempdir(), show_plots = FALSE, verbose = FALSE)
samples <- load_samples(mod_mst) * 1e5
\dontshow{
unlink(paste0(tempdir(), "\\\\test"), recursive = TRUE)
}
}
