% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulas.R
\name{cclayton}
\alias{cclayton}
\title{Clayton copula constructor}
\usage{
cclayton(theta)
}
\arguments{
\item{theta}{Positive dependence parameter (\eqn{\theta > 0}).}
}
\value{
A function of two arguments (u,v) returning log copula density.
}
\description{
Returns a function that computes the log density of the bivariate Clayton copula,
intended to be used with \code{\link{dcopula}}.
}
\details{
The Clayton copula density is
\deqn{
c(u,v;\theta) = (1+\theta) (uv)^{-(1+\theta)}
\left( u^{-\theta} + v^{-\theta} - 1 \right)^{-(2\theta+1)/\theta}, \quad \theta > 0.
}
}
\examples{
x <- c(0.5, 1); y <- c(0.2, 0.8)
d1 <- dnorm(x, 1, log = TRUE); d2 <- dbeta(y, 2, 1, log = TRUE)
p1 <- pnorm(x, 1); p2 <- pbeta(y, 2, 1)
dcopula(d1, d2, p1, p2, copula = cclayton(2), log = TRUE)
}
\seealso{
\code{\link[=cgaussian]{cgaussian()}}, \code{\link[=cgumbel]{cgumbel()}}, \code{\link[=cfrank]{cfrank()}}
}
