% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zigamma.R
\name{zigamma}
\alias{zigamma}
\alias{dzigamma}
\alias{pzigamma}
\alias{rzigamma}
\title{Zero-inflated gamma distribution}
\usage{
dzigamma(x, shape, scale, zeroprob = 0, log = FALSE)

pzigamma(q, shape, scale, zeroprob = 0, lower.tail = TRUE, log.p = FALSE)

rzigamma(n, shape, scale, zeroprob = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{shape}{positive shape parameter}

\item{scale}{positive scale parameter}

\item{zeroprob}{zero-inflation probability between 0 and 1.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return}
}
\value{
\code{dzigamma} gives the density, \code{pzigamma} gives the distribution function, and \code{rzigamma} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the zero-inflated gamma distribution.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
x <- rzigamma(1, 1, 1, 0.5)
d <- dzigamma(x, 1, 1, 0.5)
p <- pzigamma(x, 1, 1, 0.5)
}
