% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cutoff.R
\name{produce.cutoff.message}
\alias{produce.cutoff.message}
\title{Create a message about fold change and pvalues used to produce the plot.}
\usage{
produce.cutoff.message(
  data,
  FCmin,
  FCmax,
  FCstep,
  FDRflag,
  p.min,
  p.max,
  p.step
)
}
\arguments{
\item{data}{Summary statistics table from limma or DEseq2, where each row is a gene.}

\item{FCmin}{The minimum starting fold change cutoff to be checked, so the minimum fold change cutoff to be evaluated
will be FCmin + FCstep, FCmin default = 1.}

\item{FCmax}{The maximum fold change cutoff to be checked, default = 2.}

\item{FCstep}{The step from the minimum to maximum fold change cutoff, one step increase at a time, default = 0.01.}

\item{FDRflag}{The column name of the False Discovery Rate (FDR) in the summary statistics table.}

\item{p.min}{The minimum starting FDR cutoff to be checked, so the minimum fold change cutoff to be evaluated
will be p.min + p.step, p.min default = 0.}

\item{p.max}{The maximum FDR cutoff to be checked, default = 0.2.}

\item{p.step}{The step from the minimum to maximum fold change cutoff, one step increase at a time, default = 0.005.}
}
\description{
This function processes summary statistics table generated by differential expression analysis
like \code{limma} or \code{DESeq2} and produces a message about pvalues and fold change used.
}
