% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{plotTrProbs}
\alias{plotTrProbs}
\title{Function for plotting transition probabilities between clusters}
\usage{
plotTrProbs(
  object,
  probs,
  tp = 0.5,
  prthr = 0,
  cthr = 0,
  fr = FALSE,
  um = FALSE,
  cex = 0.5
)
}
\arguments{
\item{object}{\pkg{RaceID} \code{SCseq} object, updated with the \code{updateSC} function.}

\item{probs}{Matrix of transition probabilities between clusters, returned by the \code{transitionProbs} function.}

\item{tp}{Positive real number between 0 and 1. Transparency of the data points in the dimensional reduction map. Default is 0.5.}

\item{prthr}{Positive real number between 0 and 1. Threshold of transition probabilities. Only transitions with probability \code{>prthr} are
displayed in the map. Default is 0.}

\item{cthr}{Integer number greater or equal 0 defining the minimum clusters size for inclusion into the map. Default is 0.}

\item{fr}{Logical. If \code{TRUE}, then a Fruchterman-Rheingold graph layout is shown (in case it has been computed for the \pkg{RaceID} bject), otherwise a t-SNE map is shown. Default is \code{FALSE}.}

\item{um}{Logical. If \code{TRUE} then plot umap dimensional reduction representation. Default is \code{FALSE}.}

\item{cex}{Real positive number. Size of data points. Default is 0.5.}
}
\value{
None
}
\description{
This function plots the transitions probabilities in a dimensional reduction representation of a \pkg{RaceID} \code{SCseq} object updates with the
\code{updateSC} function.
in order to utilize \pkg{RaceID} functions for visualization.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
d <- getExpData(sc)
res <- pruneKnn(d,distM=sc@distances,knn=10,alpha=1,no_cores=1,FSelect=FALSE)
cl <- graphCluster(res,pvalue=0.01)
sc <- updateSC(sc,res=res,cl=cl)
sc <- comptsne(sc)
probs <-transitionProbs(res,cl,pvalue=0.01)
plotTrProbs(sc,probs,tp=.5,prthr=0,cthr=0,fr=FALSE)
}
