% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.wasserstein.R
\name{wasserstein}
\alias{wasserstein}
\title{wasserstein distance}
\usage{
wasserstein(X, Y, p = 2, ot = SBCK::OTNetworkSimplex$new())
}
\arguments{
\item{X}{[matrix or SparseHist] If matrix, dim = ( nrow = n_samples, ncol =
n_features)}

\item{Y}{[matrix or SparseHist] If matrix, dim = ( nrow = n_samples, ncol =
n_features)}

\item{p}{[float]
Power of the metric (default = 2)}

\item{ot}{[Optimal transport solver]}
}
\value{
[float] value of distance
}
\description{
Compute wasserstein distance between two dataset or SparseHist X and Y
}
\examples{
X = base::cbind( stats::rnorm(2000) , stats::rnorm(2000)  )
Y = base::cbind( stats::rnorm(2000,mean=10)  , stats::rnorm(2000) )
bw = base::c(0.1,0.1)
muX = SBCK::SparseHist( X , bw )
muY = SBCK::SparseHist( Y , bw )

## The four are equals
w2 = SBCK::wasserstein(X,Y)
w2 = SBCK::wasserstein(muX,Y)
w2 = SBCK::wasserstein(X,muY)
w2 = SBCK::wasserstein(muX,muY)

}
\references{
Wasserstein, L. N. (1969). Markov processes over denumerable
            products of spaces describing large systems of automata. Problems
            of Information Transmission, 5(3), 47-52.
}
