% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_delivery_template.R
\name{get_delivery_template}
\alias{get_delivery_template}
\title{Get a delivery template for a SHARK datatype}
\usage{
get_delivery_template(
  datatype,
  sheet = "Kolumner",
  header_row = 4,
  skip = 1,
  bacterioplankton_subtype = "abundance",
  force = FALSE,
  clean_cache_days = 1
)
}
\arguments{
\item{datatype}{Character. The datatype name.
Available options include:
\itemize{
\item "Bacterioplankton" (subtypes: "abundance", "production")
\item "Chlorophyll"
\item "Epibenthos" (dive transect)
\item "Dropvideo" (epibenthos drop video)
\item "Grey seal"
\item "Harbour seal"
\item "Ringed seal"
\item "Harbour Porpoise"
\item "Physical and Chemical"
\item "Primary production"
\item "Phytoplankton"
\item "Picoplankton"
\item "Sedimentation"
\item "Seal pathology"
\item "Profile"
\item "Zooplankton"
\item "Zoobenthos"
}}

\item{sheet}{Character or numeric. Name (e.g., "Kolumner") or index (e.g., 1) of
the sheet in the Excel file to read. Default is "Kolumner".}

\item{header_row}{Integer. Row number in the Excel file that contains the column headers.
Default is 4.}

\item{skip}{Integer. Number of rows to skip before reading data. Default is 1.}

\item{bacterioplankton_subtype}{Character. For "Bacterioplankton" only: either
"abundance" (default) or "production". Ignored for other datatypes.}

\item{force}{Logical; if \code{TRUE}, forces re-download even if cached copy exists.}

\item{clean_cache_days}{Numeric; if not \code{NULL}, cached template files older than
this number of days are deleted automatically. Default is 1.}
}
\value{
A \code{tibble} containing the delivery template. Column names are set
from the header row.
}
\description{
Downloads and reads the SHARK Excel delivery template for a given datatype.
The template contains the column definitions and headers used for submission.
}
\examples{
\donttest{
# Bacterioplankton abundance
abun <- get_delivery_template("Bacterioplankton",
                              bacterioplankton_subtype = "abundance")

print(abun)

# Bacterioplankton production
prod <- get_delivery_template("Bacterioplankton",
                              bacterioplankton_subtype = "production")

# Phytoplankton template
phyto <- get_delivery_template("Phytoplankton")

# Phytoplankton column explanation (sheet number 3)
phyto_column_explanation <- get_delivery_template("Phytoplankton",
                                                  sheet = 3,
                                                  header_row = 4,
                                                  skip = 3)

print(phyto_column_explanation)
}

}
