% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDQplot.R
\name{edqplot}
\alias{edqplot}
\title{Plot the Observed Time Series and Selected EDQs (Empirical Dynamic Quantiles)}
\usage{
edqplot(
  x,
  prob = c(0.05, 0.5, 0.95),
  h = 30,
  loc = NULL,
  color = c("yellow", "red", "green")
)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{prob}{Probability, the quantile series of which is to be computed.
Default values are 0.05, 0.5, 0.95.}

\item{h}{Number of time series used in the algorithm. Default value is 30.}

\item{loc}{Locations of the EDQ. If loc is not null, then prob is not used.}

\item{color}{Colors for plotting the EDQ. Default is "yellow", "red", and "green".}
}
\value{
The observed time series plot with the selected EDQs.
}
\description{
Plot the observed time series and selected empirical dynamic quantiles (EDQs) computed as in Peña, Tsay and Zamar (2019).
}
\examples{
data(TaiwanAirBox032017)
edqplot(TaiwanAirBox032017[1:100,1:25])

}
\references{
Peña, D. Tsay, R. and Zamar, R. (2019). Empirical Dynamic Quantiles for
Visualization of High-Dimensional Time Series, \emph{Technometrics}, 61:4, 429-444.
}
