% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMap.R
\name{plot.Map}
\alias{plot.Map}
\title{Plot Image Maps}
\usage{
\method{plot}{Map}(
  x,
  color.scheme = NULL,
  legend.ticks = 7,
  gridlines = NULL,
  gridlinecol = "red",
  gridlinelwd = 0.5,
  gridlinelty = 2,
  main = NULL,
  y.lab = NULL,
  x.lab = NULL,
  flags = NULL,
  legend.width = 1,
  legend.height = 2,
  filename = NULL,
  plot.width = 14,
  plot.height = 8,
  plot.scale = 1,
  ...
)
}
\arguments{
\item{x}{An object of class: \code{outlier_map}}

\item{color.scheme}{Which color scheme to use. Typical choices include:
\itemize{
\item \code{\link[gplots:colorpanel]{gplots::redgreen()}}
\item \code{\link[gplots:colorpanel]{gplots::bluered()}}
\item \code{\link[grDevices:palettes]{grDevices::heat.colors()}}
\item \code{\link[grDevices:palettes]{grDevices::terrain.colors()}}
\item \code{\link[grDevices:palettes]{grDevices::topo.colors()}}
\item \code{\link[RColorBrewer:ColorBrewer]{RColorBrewer::brewer.pal()}}
\item \code{\link[viridis:reexports]{viridis::viridis()}}
\item \code{\link[viridis:reexports]{viridis::magma()}}
}}

\item{legend.ticks}{How many ticks to place on the color legend.}

\item{gridlines}{Numeric vector or logical. Indicates where to draw the \emph{horizontal}
grid lines that can be used to separate samples (rows). This
should be a vector of the cumulative sum of the horizontal lines to be
drawn, typically something like \code{cumsum(table(data$Sex))}.
Alternatively, \code{TRUE} can be passed whereby the lines are determined by
the "class.tab" element of \code{x$class.tab} (if possible).}

\item{gridlinecol}{Color of the gridlines.}

\item{gridlinelwd}{Width of the gridlines.}

\item{gridlinelty}{Line type of the gridlines.}

\item{main}{Character. Main title for the plot.
See \code{\link[ggplot2:labs]{ggplot2::ggtitle()}} for \code{ggplot2} style graphics.}

\item{y.lab}{Character. Optional string for the y-axis. Otherwise
one is automatically generated (default).}

\item{x.lab}{Character. Optional string for the x-axis. Otherwise
one is automatically generated (default).}

\item{flags}{Numeric in \verb{[0, 1]}.
For an \code{"outlier_map"}, the proportion of the analytes (columns)
for a given sample that must be outliers for a flag to be placed at the right-axis,
right-axis, thus flagging that sample.
If \code{NULL} (default), \code{0.05} (5\%) is selected.}

\item{legend.width}{Width for the color legend.}

\item{legend.height}{Height for the color legend.}

\item{filename}{Optional. If provided, the plot will be written to a file.
The file name must also include the desired file type extension;
this will be used to determine the file type,
e.g. a file named \code{foo.png} will be saved as a \code{PNG}.
See \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} for a full list of file type (device) options.}

\item{plot.width}{If \code{"filename != NULL"}, the width of the plot image file.}

\item{plot.height}{If \code{"filename != NULL"}, the height of the plot image file.}

\item{plot.scale}{If \code{"filename != NULL"}, the scale of the plot image file.}

\item{...}{Arguments required by the \code{plot()} generic. Currently unused.}
}
\value{
Plot an image of the passed matrix.
}
\description{
Plotting function for objects of the \code{outlier_map} class. Produces a
heatmap-style image using \pkg{ggplot2} syntax, for objects
produced by \code{\link[=calcOutlierMap]{calcOutlierMap()}}.
}
\examples{
example_data |>
  dplyr::filter(SampleType == "Sample") |>
  head(10) |>
  calcOutlierMap() |>
  plot(flags = 0.05)
}
\seealso{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}, \code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}}

Other Calc Map: 
\code{\link{calcOutlierMap}()},
\code{\link{getOutlierIds}()}
}
\author{
Stu Field, Amanda Hiser
}
\concept{Calc Map}
