% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCimplify.R
\name{SCimplify}
\alias{SCimplify}
\title{Detection of metacells with the SuperCell approach}
\usage{
SCimplify(
  X,
  genes.use = NULL,
  genes.exclude = NULL,
  cell.annotation = NULL,
  cell.split.condition = NULL,
  n.var.genes = min(1000, nrow(X)),
  gamma = 10,
  k.knn = 5,
  do.scale = TRUE,
  n.pc = 10,
  fast.pca = TRUE,
  do.approx = FALSE,
  approx.N = 20000,
  block.size = 10000,
  seed = 12345,
  igraph.clustering = c("walktrap", "louvain"),
  return.singlecell.NW = TRUE,
  return.hierarchical.structure = TRUE,
  ...
)
}
\arguments{
\item{X}{log-normalized gene expression matrix with rows to be genes and cols to be cells}

\item{genes.use}{a vector of genes used to compute PCA}

\item{genes.exclude}{a vector of genes to be excluded when computing PCA}

\item{cell.annotation}{a vector of cell type annotation, if provided, metacells that contain single cells of different cell type annotation will be split in multiple pure metacell (may result in slightly larger numbe of metacells than expected with a given gamma)}

\item{cell.split.condition}{a vector of cell conditions that must not be mixed in one metacell. If provided, metacells will be split in condition-pure metacell (may result in significantly(!) larger number of metacells than expected)}

\item{n.var.genes}{if \code{"genes.use"} is not provided, \code{"n.var.genes"} genes with the largest variation are used}

\item{gamma}{graining level of data (proportion of number of single cells in the initial dataset to the number of metacells in the final dataset)}

\item{k.knn}{parameter to compute single-cell kNN network}

\item{do.scale}{whether to scale gene expression matrix when computing PCA}

\item{n.pc}{number of principal components to use for construction of single-cell kNN network}

\item{fast.pca}{use \link[irlba]{irlba} as a faster version of prcomp (one used in Seurat package)}

\item{do.approx}{compute approximate kNN in case of a large dataset (>50'000)}

\item{approx.N}{number of cells to subsample for an approximate approach}

\item{block.size}{number of cells to map to the nearest metacell at the time (for approx coarse-graining)}

\item{seed}{seed to use to subsample cells for an approximate approach}

\item{igraph.clustering}{clustering method to identify metacells (available methods "walktrap" (default) and "louvain" (not recommended, gamma is ignored)).}

\item{return.singlecell.NW}{whether return single-cell network (which consists of approx.N if \code{"do.approx"} or all cells otherwise)}

\item{return.hierarchical.structure}{whether return hierarchical structure of metacell}

\item{...}{other parameters of \link{build_knn_graph} function}
}
\value{
a list with components
\itemize{
  \item graph.supercells - igraph object of a simplified network (number of nodes corresponds to number of metacells)
  \item membership - assigmnent of each single cell to a particular metacell
  \item graph.singlecells - igraph object (kNN network) of single-cell data
  \item supercell_size - size of metacells (former super-cells)
  \item gamma - requested graining level
  \item N.SC - number of obtained metacells
  \item genes.use - used genes
  \item do.approx - whether approximate coarse-graining was perfirmed
  \item n.pc - number of principal components used for metacells construction
  \item k.knn - number of neighbors to build single-cell graph
  \item sc.cell.annotation. - single-cell cell type annotation (if provided)
  \item sc.cell.split.condition. - single-cell split condition (if provided)
  \item SC.cell.annotation. - super-cell cell type annotation (if was provided for single cells)
  \item SC.cell.split.condition. - super-cell split condition (if was provided for single cells)

}
}
\description{
This function detects metacells (former super-cells) from single-cell gene expression matrix
}
\examples{
\donttest{
data(cell_lines) # list with GE - gene expression matrix (logcounts), meta - cell meta data
GE <- cell_lines$GE

SC <- SCimplify(GE,  # log-normalized gene expression matrix
                gamma = 20, # graining level
                n.var.genes = 1000,
                k.knn = 5, # k for kNN algorithm
                n.pc = 10, # number of principal components to use
                do.approx = TRUE) #

}
}
