% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_genDONUTS.R
\name{genDONUTS}
\alias{genDONUTS}
\title{Generate Nested Donuts}
\usage{
genDONUTS(n = 50, k = 2, sd = 0.1)
}
\arguments{
\item{n}{the number of data points for each hollow circle (default: 50).}

\item{k}{the number of circles (default: 2).}

\item{sd}{magnitude of white noise (default: 0.1).}
}
\value{
a named list containing with \eqn{m = nk}:\describe{
\item{data}{an \eqn{(m\times 2)} data matrix.}
\item{label}{a length-\eqn{m} vector(factor) for class labels.}
}
}
\description{
It generates nested \emph{donuts}, which are just hollow circles. For flexible 
testing, the parameter \code{k} controls the number of circles of varying 
radii where \code{n} controls the number of observations for each circle.
}
\examples{
\donttest{
## generate data
donut2 = genDONUTS(k=2)
donut3 = genDONUTS(k=3)
donut4 = genDONUTS(k=4)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
plot(donut2$data, col=donut2$label, pch=19, main="k=2")
plot(donut3$data, col=donut3$label, pch=19, main="k=3")
plot(donut4$data, col=donut4$label, pch=19, main="k=4")
par(opar)
}

}
\concept{data}
