% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_TAAG.R
\name{check.TAAG}
\alias{check.TAAG}
\title{Check TAAG}
\usage{
check.TAAG(object)
}
\arguments{

\item{object}{object of class inheriting from "TAAG".}

}
\description{
This function provides a table for checking whther the TAAG process fits the data well better than an ordinary kriging model.
}
\value{
A table of the fitted negative likelihood values and cross validation errors obtained from TAAG and the ordinary kriging models from dicekriging and mlegp is returned. Note that, for both criteria, the model with a smaller value are a better model.
}
\references{
Lin, L.-H. and Joseph,  V. R. (2020) "Transformation and Additivity in Gaussian Processes",\emph{Technometrics}, 62, 525-535.  DOI:10.1080/00401706.2019.1665592.
}
\seealso{
  \code{\link{TAAG}} for the estimates of the parameters in the TAG and TAAG, respectively.
}
\examples{
n <- 20
p <- 2
library(randtoolbox)
X <-  sobol(n, dim = p, init = TRUE, scrambling = 2, seed = 20, normal = FALSE)
y <- exp(2*sin(0.5*pi*X[,1]) + 0.5*cos(2.5*pi*X[,2]))
ini.TAG <- initial.TAG(y, X)
par.TAG <- TAG(ini.TAG)
N <- 1000
X.test <- sobol(N, dim = p, init = TRUE, scrambling = 2, seed = 5, normal = FALSE)
ytrue  <- exp(2*sin(0.5*pi*X.test[,1]) + 0.5*cos(2.5*pi*X.test[,2]))
pre.TAG <- pred.TAG(par.TAG, X.test)
library(DiceKriging)
set.seed(2)
temp.m <- km(formula=~1, design=X, response=par.TAG$ty,
             covtype="gauss",nugget = (10^-15), multistart = 4,
             control = list(trace = FALSE))
nu.est <- sqrt(2*(coef(temp.m)$range^2))
par.TAAG <- TAAG(par.TAG, nu.est)

check.table <- check.TAAG(par.TAAG)
check.table
}
\keyword{Model Comparision}
