% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_9e.R
\name{get_clinical_data}
\alias{get_clinical_data}
\title{Retrieve Clinical Information for a Cancer Study.}
\usage{
get_clinical_data(csid, case_list_id = NULL, dryrun = FALSE)
}
\arguments{
\item{csid}{String corresponding to a TCGA Cancer Study identifier.}

\item{case_list_id}{String corresponding to the case_list identifier of interest. This Can be NULL.}

\item{dryrun}{Logical. If TRUE, all other arguments (if any) are ignored and 
a representative example is returned as output. No Internet connection is 
required for executing the operation when `dryrun` is TRUE.}
}
\value{
data.frame including clinical information of a list of 
samples/cases of interest.
}
\description{
Retrieve Clinical Information about the samples included in a cancer study of interest. 
For each sample/case, information about the corresponding cancer patient are returned. 
These may include sex, age, therapeutic regimen, tumor stage, 
survival status, as well as other information.
}
\examples{
# Set `dryrun = FALSE` (default option) in production!
clinic_data <- get_clinical_data("blca_tcga", dryrun = TRUE)  
utils::head(clinic_data[, 1:7])
 


}
\references{
\url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
