% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC_TFM.R
\name{SPC_TFM}
\alias{SPC_TFM}
\title{Sparse Principal Component Analysis}
\usage{
SPC_TFM(data, A, D, m, p)
}
\arguments{
\item{data}{The data used in the SPC analysis.}

\item{A}{The true factor loadings matrix.}

\item{D}{The true uniquenesses matrix.}

\item{m}{The number of common factors.}

\item{p}{The number of variables.}
}
\value{
A list containing:
\item{As}{Estimated factor loadings, a matrix of estimated factor loadings from the SPC analysis.}
\item{Ds}{Estimated uniquenesses, a vector of estimated uniquenesses corresponding to each variable.}
\item{MSESigmaA}{Mean squared error of the estimated factor loadings (As) compared to the true loadings (A).}
\item{MSESigmaD}{Mean squared error of the estimated uniquenesses (Ds) compared to the true uniquenesses (D).}
\item{LSigmaA}{Loss metric for the estimated factor loadings (As), indicating the relative error compared to the true loadings (A).}
\item{LSigmaD}{Loss metric for the estimated uniquenesses (Ds), indicating the relative error compared to the true uniquenesses (D).}
\item{tau}{Proportion of zero factor loadings in the estimated loadings matrix (As).}
}
\description{
This function performs Sparse Principal Component Analysis (SPC) on the input data. It estimates factor loadings and uniquenesses while calculating mean squared errors and loss metrics for comparison with true values. Additionally, it computes the proportion of zero factor loadings.
}
\examples{
\dontrun{
library(MASS)
library(relliptical)
library(SOPC)
SPC_MSESigmaA <- c()
SPC_MSESigmaD <- c()
SPC_LSigmaA <- c()
SPC_LSigmaD <- c()
SPC_tau <- c()
result <- SPC_TFM(data, A, D, m, p)
print(result)}
}
