% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StepDiscrim.R
\name{SameDiscrim}
\alias{SameDiscrim}
\title{Allows to select the same variables for a given StepDiscrim}
\usage{
SameDiscrim(MWA, MWADiscrim)
}
\arguments{
\item{MWA}{MultiWaveAnalysis object on which variables are to be selected.}

\item{MWADiscrim}{MultiWaveAnalysis object on which certain variables have been
previously selected, using \code{\link{StepDiscrim}} or
\code{\link{StepDiscrimV}}}
}
\value{
An object of class MultiWaveAnalysis with the same variables selected as in the
MWADiscrim object.
}
\description{
Allows to perform the same variable selection in a new MWA object starting
from a MWA object with the variables already selected (it is advisable that
the parameters of the MWA and of the selection are the same).
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
# We simulate that the second series has been obtained after
Series1 <- ECGExample[, , 1:9]
Series2 <- ECGExample[, , 10, drop = FALSE]
MWA <- MultiWaveAnalysis(Series1, "haar", features = c("var"))
MWADiscrim <- StepDiscrim(MWA, c(rep(1, 5), rep(2, 4)), 5,
  features = c("var")
)

MWA2 <- MultiWaveAnalysis(Series2, "haar", features = c("var"))
MWA2Discrim <- SameDiscrim(MWA2, MWADiscrim)
# At this point MWA2Discrim has the same variables that MWADiscrim
# and can be used in a pretrained model with MWADiscrim
}

}
\seealso{
\itemize{
\item \code{\link{StepDiscrim}}
\item \code{\link{StepDiscrimV}}
}
}
