% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Theta.tuning.R
\name{Theta.tuning}
\alias{Theta.tuning}
\title{Fast sparse precision matrix estimation.}
\usage{
Theta.tuning(lambda2, S.hat.A, delta.hat, Omega.hat0, n.A,
                    theta.algm="cd", adjust.BIC=FALSE)
}
\arguments{
\item{lambda2}{A vector, a sequence of tuning parameters.}

\item{S.hat.A}{The sample covariance matrix.}

\item{delta.hat}{The divergence matrix estimated in step 2(a). If the precision matrix is estimated in the common case (Liu and Luo, 2015, JMVA), it can be set to zero matrix.}

\item{Omega.hat0}{The initial values of the precision matrix.}

\item{n.A}{The sample size.}

\item{theta.algm}{The optimization algorithm used to solve \eqn{\widehat{\Omega}}{\widehat{\Omega}} in step 2(b), which can be selected as "admm" (ADMM algorithm) or "cd" (coordinate descent).}

\item{adjust.BIC}{Whether to use the adjusted BIC to select lambda2, the default setting is F.}
}
\value{
A result list including:
Theta.hat.m: the optimal precision matrix;
BIC.summary: the summary of BICs;
Theta.hat.list.m: the precision matrices corresponding to a sequence of tuning parameters.
}
\description{
The fast sparse precision matrix estimation in step 2(b).
}
\examples{
p = 20
n = 200
omega = diag(rep(1,p))
for (i in 1:p) {
  for (j in 1:p) {
    omega[i,j] = 0.3^(abs(i-j))*(abs(i-j) < 2)
  }
}
Sigma = solve(omega)
X = MASS::mvrnorm(n, rep(0,p), Sigma)
S.hat.A = cov(X)
delta.hat = diag(rep(1,p)) - diag(rep(1,p))
lambda2 = seq(0.1,0.5,length.out =10)
res = Theta.tuning(lambda2, S.hat.A, delta.hat, n.A=n)
omega.hat = res$Theta.hat.m



}
\references{
Ren, M., Zhen Y., and Wang J. (2022). Transfer learning for tensor graphical models.
Liu, W. and Luo X. (2015). Fast and adaptive sparse precision matrix estimation in high dimensions, Journal of Multivariate Analysis.
}
\author{
Mingyang Ren, Yaoming Zhen, Junhui Wang. Maintainer: Mingyang Ren \href{mailto:renmingyang17@mails.ucas.ac.cn}{renmingyang17@mails.ucas.ac.cn}.
}
