% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kendall_tauc.R
\name{Kendall_tauc}
\alias{Kendall_tauc}
\title{Kendall's Tau_c and its asymptotic standard errors}
\usage{
Kendall_tauc(y, fx)
}
\arguments{
\item{y}{a vector of realized categories.}

\item{fx}{a vector of predicted values of the ranking function f.}
}
\value{
A list of length three is returned, containing the following components:
\item{val}{Kendall's Tau_c}
\item{ASE}{the asymptotic standard error of Kendall's Tau_c}
\item{ASE0}{the modified asymptotic error of Kendall's Tau_c under the null hypothesis}
}
\description{
Computes Kendall's Tau_c on a given cartesian product Y x f(X), where Y consists of the components of \code{y} and f(X) consists of the components of \code{fx}. Furthermore, the asymptotic standard error as well as the modified asymptotic standard error to test the null hypothesis that the measure is zero are provided as defined in Brown and Benedetti (1977).
}
\examples{
Kendall_tauc(rep(1:5,each=3),c(3,3,3,rep(2:5,each=3)))
}
\references{
Brown, M.B., Benedetti, J.K., 1977. Sampling Behavior of Tests for Correlation in Two-Way Contingency Tables. Journal of the American Statistical Association 72(358), 309-315
}
