% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.f.BGM.boot1.R
\name{bw.f.BGM.boot1}
\alias{bw.f.BGM.boot1}
\title{\insertCite{borrajo2017;textual}{WData} bootstrap bandwidth selector for \insertCite{jones1991;textual}{WData} kernel density estimator}
\usage{
bw.f.BGM.boot1(
  y,
  w = function(y) {
     ifelse(y >= 0, y, NA)
 },
  kernel = c("gaussian", "epanechnikov", "rectangular", "triangular", "biweight",
    "cosine", "optcosine"),
  bw0 = c("RT", "PI")
)
}
\arguments{
\item{y}{A numeric vector containing the biased sample.}

\item{w}{A function representing the bias function applied to the data points. It must be evaluable and positive in each point of the sample \code{y}. By default, it is set to the length-biased function.}

\item{kernel}{A character string specifying the kernel function. Available options: \code{"gaussian"}, \code{"epanechnikov"}, \code{"rectangular"}, \code{"triangular"}, \code{"biweight"}, \code{"cosine"} and \code{"optcosine"}.}

\item{bw0}{A character string specifying the method to determine the pilot bandwidth. Options are \code{"RT"} for rule of thumb and \code{"PI"} for plug-in bandwidth. Default is \code{"RT"}.}
}
\value{
The bootstrap bandwidth value.
}
\description{
This function computes the bandwidth selector for \insertCite{jones1991;textual}{WData} kernel density estimator using the bias-corrected bootstrap method developed by \insertCite{borrajo2017;textual}{WData}.
}
\details{
When \code{bw0="RT"}, the bandwidth is given by
\deqn{
\widehat{h}_{f, \mathrm{B}_{\mathrm{RT}}}= \left( \frac{R(K^{\ast})\widehat{\mu}_w\widehat{\bar{\mu}}_w}{n \eta(K^{\ast})^{2} R\left(\widehat{f}_{J,\widehat{h}_{f, 0,\mathrm{RT}}}^{(2)}\right)}\right)^{1/5},
\quad
\text{where} \quad
\widehat{h}_{f, 0, \mathrm{RT}}= \frac{n^{1/5}}{n^{1/7}} \widehat{h}_{f, \mathrm{RT}}.
}
\eqn{\widehat{h}_{f, \mathrm{RT}}} is the value returned by \code{\link[=bw.f.BGM.rt]{bw.f.BGM.rt}}. An alternative is to consider the following pilot bandwidth:
\deqn{
\widehat{h}_{f, \mathrm{B}_{\mathrm{opt}}}= \left( \frac{R(K^{\ast})\widehat{\mu}_w\widehat{\bar{\mu}}_w}{n \eta(K^{\ast})^{2} R\left(\widehat{f}_{J,\widehat{h}_{f, 0,\mathrm{opt}}}^{(2)}\right)}\right)^{1/5},
\quad
\text{where} \quad
\widehat{h}_{f, 0, \mathrm{opt}}= \left(\frac{5 \widehat{\mu}_w\widehat{\bar{\mu}}_w R\left(L^{(2)}\right)  }{2 n \eta(L)  R\left(f^{(3)}\right) } \right)^{1 / 7}
}
and \eqn{R(f^{(3)})} is estimated under the assumption that \eqn{f} is gaussian, which is implemented by setting \code{bw0="PI"}. The quantities \eqn{R(K^{\ast})} and \eqn{\eta(K^{\ast})^{2}} depend only on the kernel and are defined as
\deqn{
R(K^{\ast}) = \int_{-\infty}^{+\infty} K^{\ast}(u)^2 du
\quad \text{and} \quad
\eta(K^{\ast}) = \int_{-\infty}^{+\infty} u^2 K^{\ast}(u) du.
}
The estimators \eqn{\widehat{\mu}_w} and \eqn{\widehat{\bar{\mu}}_w} are given by
\deqn{
\widehat{\mu}_w = n \left(\sum_{i=1}^{n}  \frac{1}{w(Y_i)} \right)^{-1}
\quad \text{and} \quad
\widehat{\bar{\mu}}_w = \frac{\widehat{\mu}_w}{n} \sum_{i=1}^{n} \frac{1}{w(Y_i)^2}.
}
}
\examples{
# Bandwidth value using bootstrap method with "RT" as pilot bandwidth
bw.f.BGM.boot1(y = shrub.data$Width)
# Bandwidth value using bootstrap method with "PI" as pilot bandwidth
bw.f.BGM.boot1(y = shrub.data$Width, bw0 = "PI")
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=df.jones]{df.jones}}
}
