% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zscore.R
\name{Zscore}
\alias{Zscore}
\title{Z-transformation for input matrix.}
\usage{
Zscore(countMat, negGene)
}
\arguments{
\item{countMat}{input data set. The siRNA/gene x readouts matrix from HTS2 or large-scale RNAi screens.}

\item{negGene}{negative control dataset, the siRNAs/genes used as negative controls in screening. Z-transfromation according to thses negative control siRNAs/genes for each readout.}
}
\value{
A Z-transformated matrix, where each row represents each knocking-down condition and each column is a specific readout (AS event). The values in the matrix are the normalized values(Z-scores).
}
\description{
In this step, the input matrix is transformed to Z-score matrix.
}
\details{
The initial input matrix is arranged in N x M dimension, where each row contains individual functional readouts against a siRNA pool and each column corresponds to individually siRNA pools tested on a given functional readout. Readouts in each column may be thus considered as the data from one-dimensional screen (many-to-one), and thus, the typical Z statistic can be used to evaluate the relative function of individual genes in such column. The conversion is repeated on all columns, thereby converting the raw activity matrix into a matrix. Suppose Nij are the values in the original matrix i (1 <= i <= N siRNA pool) row and j ( 1 <= j <= M readout) column, then Zij = (Nij - uj) / sigma(j), where uj and sigma(j) are the mean and standard deviation of negative control samples in column j.
}
\examples{
data(countMat)
data(negGene)
ZscoreVal <- Zscore(countMat,negGene)
ZscoreVal[1:5,1:5]

}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{Zscore}
