% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arxiv_search.R
\name{arxiv_search}
\alias{arxiv_search}
\title{The main search function for aRxiv}
\usage{
arxiv_search(
  query = NULL,
  id_list = NULL,
  start = 0,
  limit = 10,
  sort_by = c("submitted", "updated", "relevance"),
  ascending = TRUE,
  batchsize = 100,
  force = FALSE,
  output_format = c("data.frame", "list"),
  sep = "|"
)
}
\arguments{
\item{query}{Search pattern as a string; a vector of such strings
also allowed, in which case the elements are combined with \code{AND}.}

\item{id_list}{arXiv doc IDs, as comma-delimited string or a vector
of such strings}

\item{start}{An offset for the start of search}

\item{limit}{Maximum number of records to return (must be > 0).}

\item{sort_by}{How to sort the results (ignored if \code{id_list} is
provided)}

\item{ascending}{If TRUE, sort in ascending order; else descending
(ignored if \code{id_list} is provided)}

\item{batchsize}{Maximum number of records to request at one time}

\item{force}{If TRUE, force search request even if it seems extreme}

\item{output_format}{Indicates whether output should be a data frame or a list.}

\item{sep}{String to use to separate multiple authors,
affiliations, DOI links, and categories, in the case that
\code{output_format="data.frame"}.}
}
\value{
If \code{output_format="data.frame"}, the result is a data
frame with each row being a manuscript and columns being the
various fields.

If \code{output_format="list"}, the result is a list parsed from
the XML output of the search, closer to the raw output from arXiv.

The data frame format has the following columns.
\tabular{rll}{
[,1] \tab id               \tab arXiv ID \cr
[,2] \tab submitted        \tab date first submitted \cr
[,3] \tab updated          \tab date last updated \cr
[,4] \tab title            \tab manuscript title \cr
[,5] \tab summary          \tab abstract \cr
[,6] \tab authors          \tab author names \cr
[,7] \tab affiliations     \tab author affiliations \cr
[,8] \tab link_abstract    \tab hyperlink to abstract \cr
[,9] \tab link_pdf         \tab hyperlink to pdf \cr
[,10] \tab link_doi         \tab hyperlink to DOI \cr
[,11] \tab comment          \tab authors' comment \cr
[,12] \tab journal_ref      \tab journal reference \cr
[,13] \tab doi              \tab published DOI \cr
[,14] \tab primary_category \tab primary category \cr
[,15] \tab categories       \tab all categories \cr
}

The contents are all strings; missing values are empty strings (\code{""}).

The columns \code{authors}, \code{affiliations}, \code{link_doi},
and \code{categories} may have multiple entries separated by
\code{sep} (by default, \code{"|"}).

The result includes an attribute \code{"search_info"} that includes
information about the details of the search parameters, including
the time at which it was completed. Another attribute
\code{"total_results"} is the total number of records that match
the query.
}
\description{
Allows for progammatic searching of the arXiv pre-print repository.
}
\examples{
\dontshow{old_delay <- getOption("aRxiv_delay")
          options(aRxiv_delay=1)}
\donttest{
# search for author Peter Hall with deconvolution in title
z <- arxiv_search(query = 'au:"Peter Hall" AND ti:deconvolution', limit=2)
attr(z, "total_results") # total no. records matching query
z$title

# search for a set of documents by arxiv identifiers
z <- arxiv_search(id_list = c("0710.3491v1", "0804.0713v1", "1003.0315v1"))
# can also use a comma-separated string
z <- arxiv_search(id_list = "0710.3491v1,0804.0713v1,1003.0315v1")
# Journal references, if available
z$journal_ref

# search for a range of dates (in this case, one day)
z <- arxiv_search("submittedDate:[199701010000 TO 199701012359]", limit=2)
}
\dontshow{options(aRxiv_delay=old_delay)}

}
\seealso{
\code{\link[=arxiv_count]{arxiv_count()}}, \code{\link[=arxiv_open]{arxiv_open()}},
\code{\link[=query_terms]{query_terms()}}, \code{\link[=arxiv_cats]{arxiv_cats()}}
}
