% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_one_to_one}
\alias{assert_one_to_one}
\title{Is There a One to One Mapping between Variables?}
\usage{
assert_one_to_one(
  dataset,
  vars1,
  vars2,
  dataset_name = rlang::caller_arg(dataset),
  message = NULL,
  class = "assert_one_to_one",
  call = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset to be checked

The variables specified for \code{vars1} and \code{vars2} are expected.

\describe{
\item{Default value}{none}
}}

\item{vars1}{First list of variables

\describe{
\item{Default value}{none}
}}

\item{vars2}{Second list of variables

\describe{
\item{Default value}{none}
}}

\item{dataset_name}{string indicating the label/symbol of the object being checked.

\describe{
\item{Default value}{\code{rlang::caller_arg(dataset)}}
}}

\item{message}{string passed to \code{cli::cli_abort(message)}. When \code{NULL}, default messaging
is used (see examples for default messages). \code{"dataset_name"} can be used in messaging.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{class}{Subclass of the condition.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
An error if the condition is not meet. The input otherwise.
}
\description{
Checks if there is a one to one mapping between two lists of variables.
}
\examples{
library(dplyr)
library(rlang)

df <- tribble(
  ~SPECIES, ~SPECIESN,
  "DOG",           1L,
  "CAT",           2L,
  "DOG",           1L
)

assert_one_to_one(df, vars1 = exprs(SPECIES), vars2 = exprs(SPECIESN))

df_many <- tribble(
  ~SPECIES, ~SPECIESN,
  "DOG",           1L,
  "CAT",           2L,
  "DOG",           3L
)

try(
  assert_one_to_one(df_many, vars1 = exprs(SPECIES), vars2 = exprs(SPECIESN))
)

try(
  assert_one_to_one(df_many, vars1 = exprs(SPECIESN), vars2 = exprs(SPECIES))
)
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr}()},
\code{\link{assert_expr_list}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
