% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{count_snps}
\alias{count_snps}
\title{Count the number/proportion of present/missing sites in each sample}
\usage{
count_snps(data, missing = FALSE, prop = FALSE)
}
\arguments{
\item{data}{EIGENSTRAT data object.}

\item{missing}{Count present SNPs or missing SNPs?}

\item{prop}{Calculate the proportion instead of counts?}
}
\value{
A data.frame object with SNP counts/proportions.
}
\description{
Count the number/proportion of present/missing sites in each sample
}
\examples{
\dontrun{snps <- eigenstrat(download_data(dirname = tempdir()))

present_count <- count_snps(snps)
missing_count <- count_snps(snps, missing = TRUE)

present_proportion <- count_snps(snps, prop = TRUE)
missing_proportion <- count_snps(snps, missing = TRUE, prop = TRUE)
}

}
