% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partialised.R
\name{new_partialised}
\alias{new_partialised}
\title{Create partialised functions}
\usage{
new_partialised(f, args, ..., class = character())
}
\arguments{
\item{f}{A function.}

\item{args}{A list of default arguments.}

\item{...}{Additional arguments for attributes.}

\item{class}{Name of subclass.}
}
\value{
A \code{adverbial_function_partial} function.
}
\description{
Create partialised functions
}
\examples{
dist <- function(x, y) {
  sqrt(x ^ 2 + y ^ 2)
}
pdist <- new_partialised(dist, list(x = 3))
pdist(y = 4)

}
\seealso{
\code{\link[purrr:partial]{purrr::partial()}}
}
