% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.afmdata.R
\name{summary.afmdata}
\alias{summary.afmdata}
\title{Summary of an \code{afmdata} class object.}
\usage{
\method{summary}{afmdata}(object, plt = TRUE, ...)
}
\arguments{
\item{object}{An object of \code{afmdata} class.}

\item{plt}{Logical variable. If TRUE plots all available segments with all available
data.}

\item{...}{Additional arguments (for compatibility with \code{summary})}
}
\description{
This function sumarizes the main features of an afmdata object and,
optionnaly plots all segments available with all parameters estimated.
}
\examples{
\dontrun{path <- path.package("afmToolkit")
data <- afmReadJPK("force-save-JPK-3h.txt.gz", path = path)
data <- afmContactPoint(data, width = 20, mul1 = 1, mul2 = 10)
data <- afmDetachPoint(data, width = 20, mul1 = 2, mul2 = 30)
data <- afmBaselineCorrection(data)
data <- afmAdhesionEnergy(data, width = 20, mul = 10)
data <- afmZeroPointSlope(data, segment = "approach")
data <- afmIndentation(data)
data <- afmYoungModulus(data, thickness = 1e-7, params = list(alpha = 22),
                        silent = TRUE)
data <- afmExpDecay(data, nexp = 2, type = "CH")
summary(data)}                        
}

