% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrawlFunctions-trawl.R
\name{acf_supIG}
\alias{acf_supIG}
\title{Autocorrelation function of the supIG trawl function}
\usage{
acf_supIG(x, delta, gamma)
}
\arguments{
\item{x}{The argument (lag) at which the autocorrelation function associated
with the supIG trawl function will be evaluated}

\item{delta}{parameter in the supIG trawl}

\item{gamma}{parameter in the supIG trawl}
}
\value{
The autocorrelation function of the supIG trawl function evaluated at
 x
}
\description{
This function computes the autocorrelation function associated with the supIG
trawl function.
}
\details{
The trawl function is parametrised by the two parameters \eqn{\delta
 \geq 0} and \eqn{\gamma \geq 0} as follows: \deqn{g(x) =
 (1-2x\gamma^{-2})^{-1/2}\exp(\delta \gamma(1-(1-2x\gamma^{-2})^{1/2})),
 \mbox{ for } x \le 0.} It is assumed that \eqn{\delta} and \eqn{\gamma} are
 not simultaneously equal to zero. Its autocorrelation function is given by:
 \deqn{r(x) = \exp(\delta\gamma (1-\sqrt{1+2 x/\gamma^2})),  \mbox{ for } x
 \ge 0.}
}
\examples{
acf_supIG(1,0.3,0.1)
}
