% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive_read.R
\name{archive_read}
\alias{archive_read}
\title{Create a readable connection to a file in an archive.}
\usage{
archive_read(
  archive,
  file = 1L,
  mode = "r",
  format = NULL,
  filter = NULL,
  options = character(),
  password = NA_character_
)
}
\arguments{
\item{archive}{\code{character(1)} The archive filename or an \code{archive} object.}

\item{file}{\code{character(1) || integer(1)} The filename within the archive,
specified either by filename or by position.}

\item{mode}{\code{character(1)} A description of how to open the
connection (if it should be opened initially).  See section
‘Modes’ in \code{\link[base:connections]{base::connections()}} for possible values.}

\item{format}{\code{character(1)} default: \code{NULL} The archive format, one of \eval{choices_rd(names(archive:::archive_formats()))}.
Supported formats differ depending on the libarchive version and build.}

\item{filter}{\code{character(1)} default: \code{NULL} The archive filter, one of \eval{choices_rd(names(archive:::archive_filters()))}.
Supported filters differ depending on the libarchive version and build.}

\item{options}{\code{character()} default: \code{character(0)} Options to pass to the filter or format.
The list of available options are documented in
options can have one of the following forms:
\itemize{
\item \code{option=value}
The option/value pair will be provided to every module.
Modules that do not accept an option with this name will
ignore it.
\item \code{option}
The option will be provided to every module with a value
of "1".
\item \code{!option}
The option will be provided to every module with a NULL
value.
\item \code{module:option=value}, \code{module:option}, \code{module:!option}
As above, but the corresponding option and value will be
provided only to modules whose name matches module.
See \href{https://man.freebsd.org/cgi/man.cgi?query=archive_read_set_options&sektion=3&format=html}{read options} for available read options
See \href{https://man.freebsd.org/cgi/man.cgi?query=archive_write_set_options&sektion=3&format=html}{write options} for available write options
}}

\item{password}{\code{character(1)} The password to process the archive.}
}
\value{
An 'archive_read' connection to the file within the archive to be read.
}
\description{
Create a readable connection to a file in an archive.
}
\examples{
a <- system.file(package = "archive", "extdata", "data.zip")
# Show files in archive
a

# By default reads the first file in the archive.
read.csv(archive_read(a), nrows = 3)

# Can also specify a filename directly
read.csv(archive_read(a, "mtcars.csv"), nrows = 3)

# Or by position
read.csv(archive_read(a, 3), nrows = 3)

# Explicitly specify the format and filter if automatic detection fails.
read.csv(archive_read(a, format = "zip"), nrows = 3)
}
