% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_raster.R
\name{raster_colors,SpatRaster-method}
\alias{raster_colors,SpatRaster-method}
\title{Convert SpatRaster into data.frame of colors that can be used for plotting}
\usage{
\S4method{raster_colors}{SpatRaster}(x)
}
\arguments{
\item{x}{A SpatRaster object}
}
\value{
A data.frame with 3 columns and \code{length(raster_object)} rows
}
\description{
This function is used internally by \code{\link{plot_layer}} to convert a
SpatRaster object to a data.frame of colors for each pixel that can be used
for plotting with ggplot2. Note that this function assumes that the
SpatRaster objects use RGB values.
}
\examples{
\dontrun{
wi_leaf_off_layer <- get_image_layer(wi_leaf_off_url, wis_poly)
wi_leaf_off_data <- raster_colors(wi_leaf_off_layer)
}
}
