% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_routines.R
\name{subtree_at}
\alias{subtree_at}
\title{Extract a sub-tree.}
\usage{
subtree_at(obj, at_node, preserve_call = FALSE)
}
\arguments{
\item{obj}{An object of class TreeHarp}

\item{at_node}{The root of the new sub-tree. An integer, not a label, that
corresponds to BFS indexing of the tree.}

\item{preserve_call}{A logical value that indicates if a sub-call should be 
extracted. This might be slower, but it allows you to evaluate it later.}
}
\value{
An object of class TreeHarp.
}
\description{
Extracts a sub-tree rooted at a particular node.
}
\details{
This is meant for internal use, so the nodeTypes slot is silently
dropped, unless preserve_call is set to TRUE
}
\examples{
th3 <- list(a= c(2L,3L,4L), b=NULL, c=c(5L, 6L), d=7L, e=NULL, f=NULL, g=NULL)
subtree_at(TreeHarp(th3), 3)
st <- subtree_at(TreeHarp(th3), 4)
plot(st)
}
