% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_sync_encode}
\alias{am_sync_encode}
\title{Generate a sync message}
\usage{
am_sync_encode(doc, sync_state)
}
\arguments{
\item{doc}{An Automerge document}

\item{sync_state}{A sync state object (created with \code{am_sync_state()})}
}
\value{
A raw vector containing the encoded sync message, or \code{NULL} if no
message needs to be sent.
}
\description{
Generates a synchronization message to send to a peer. This message contains
the changes that the peer needs to bring their document up to date with yours.
}
\details{
If the function returns \code{NULL}, it means there are no more messages to send
(synchronization is complete from this side).
}
\examples{
doc <- am_create()
sync_state <- am_sync_state()

# Generate first sync message
msg <- am_sync_encode(doc, sync_state)
if (!is.null(msg)) {
  # Send msg to peer...
}

am_close(doc)

}
