% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_sync_state_encode}
\alias{am_sync_state_encode}
\title{Serialize a sync state}
\usage{
am_sync_state_encode(sync_state)
}
\arguments{
\item{sync_state}{A sync state object (created with \code{\link[=am_sync_state]{am_sync_state()}})}
}
\value{
A raw vector containing the serialized sync state.
}
\description{
Encodes a sync state to a raw vector for persistence or transmission.
The encoded state can later be restored with \code{\link[=am_sync_state_decode]{am_sync_state_decode()}}.
}
\details{
This is useful for persisting sync progress across sessions, avoiding
the need to re-sync from scratch.
}
\examples{
sync_state <- am_sync_state()

# Encode for storage
bytes <- am_sync_state_encode(sync_state)
bytes

# Restore later
restored <- am_sync_state_decode(bytes)
restored

}
\seealso{
\code{\link[=am_sync_state_decode]{am_sync_state_decode()}}, \code{\link[=am_sync_state]{am_sync_state()}}
}
