% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{s_date_FPR}
\alias{s_date_FPR}
\title{Make false positive rate (FPR) design matrix for dates with R format.}
\usage{
s_date_FPR(Rdate, Y, basis = "ps", dof = 10, ...)
}
\arguments{
\item{Rdate}{a vector of dates of R format}

\item{Y}{Binary case/control status; 1 for case; 0 for controls}

\item{basis}{"ps" for penalized-splines based
on B-spline basis functions}

\item{dof}{Degree-of-freedom for the bases.For "ps" basis,
the number of columns is \code{dof}
if \code{intercept=TRUE}; \code{dof-1} if \code{FALSE}.}

\item{...}{Other arguments as in \code{\link[splines:bs]{splines::bs()}}}
}
\value{
Design matrix for FPR regression, with cases' rows on top of
controls'.
}
\description{
\code{s_date_FPR} creates design matrices for FPR regressions;
}
\examples{

data(data_nplcm_reg_nest)
s_date_FPR(data_nplcm_reg_nest$X$DATE,data_nplcm_reg_nest$Y,basis='ps',dof=7)


}
\seealso{
\code{\link[=nplcm]{nplcm()}}
}
