% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_goal_func.R
\name{bayes_goal_func}
\alias{bayes_goal_func}
\title{Decision Making using Rate of Correct Classification}
\usage{
bayes_goal_func(n, Xn = NULL, K, pi, sigsq, u, beta_0, beta_1)
}
\arguments{
\item{n}{sample size (vector or scalar).}

\item{Xn}{design matrix that characterizing the data. This is
specifically given by the normal linear regression model
\deqn{yn = Xn\beta + \epsilon,} \deqn{\epsilon ~ N(0, \sigma^2 I_n),}
where \eqn{I_n} is an \eqn{n} by \eqn{n} identity matrix.
When set to \code{NULL}, an appropriate \code{Xn} is automatically generated
\code{bayesassurance::gen_Xn()}. Note that setting \code{Xn = NULL}
also enables user to pass in a vector of sample sizes to undergo
evaluation as the function will automatically adjust \code{Xn} accordingly
based on the sample size.}

\item{K}{The amount of utility associated with \eqn{H0} being correctly
accepted.The null hypothesis is not rejected if the posterior probability
of \eqn{H0} is at least \eqn{1/(1+K)}.}

\item{pi}{constant corresponding to the prior on parameter \eqn{\beta}
such that \eqn{P(u'\beta_0) = 1 - P(u'\beta_1) = \pi}.}

\item{sigsq}{variance constant of the linear regression model}

\item{u}{fixed scalar or vector of the same dimension as \eqn{\beta_0} and
\eqn{\beta_1}}

\item{beta_0}{fixed scalar or vector that null hypothesis is set to}

\item{beta_1}{fixed scalar or vector that alternative hypothesis is set to}
}
\value{
a list of objects corresponding to the rate of classifications
\itemize{
\item{rc_table:} table of sample size and corresponding correct
classification rates
\item{rc_plot:} plot of correct classification rates for varying
sample sizes
}
}
\description{
Determines the rate of correctly classifying the linear hypothesis
as true or false, where the hypothesis test is specified as
\deqn{H0: u'\beta = c0} \deqn{vs.} \deqn{H1: u'\beta = c1}. See
vignette for more details.
}
\examples{
## Example
n <- seq(100, 1200, 10)
out <- bayesassurance::bayes_goal_func(n, Xn = NULL, K = 1, pi = 0.5,
sigsq = 1, u = 1, beta_0 = 0.5, beta_1 = 0.6)
out$rc_plot
}
