% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression_Functions.R
\name{par_distreg}
\alias{par_distreg}
\title{Parallel compute bayesian distribution regression}
\usage{
par_distreg(thresh, data0, fn = distreg, no_cores = 1,
  type = "PSOCK", ...)
}
\arguments{
\item{thresh}{vector of threshold values.}

\item{data0}{the original data set with a continous dependent variable in the first column}

\item{fn}{bayesian distribution regression function. the default is distreg provided in the package}

\item{no_cores}{number of cores for parallel computation}

\item{type}{\code{type} passed to \code{makeCluster()} in the package \code{parallel}}

\item{...}{any additional input parameters to pass to fn}
}
\value{
mat a G x M matrix of output (G is the length of thresh, M is the number of draws)
}
\description{
\code{par_distreg} uses parallel computation to compute bayesian distribution regression for a given
vector of threshold values and a data (with first column being the continuous outcome variable)
}
\examples{
data0=faithful[,c(2,1)]; qnts<-quantile(data0[,1],c(0.05,0.25,0.5,0.75,0.95))
out<- par_distreg(qnts,data0,no_cores=1,iter = 102, burn = 2)
par(mfrow=c(3,2));invisible(apply(out,1,function(x)plot(density(x,30))));par(mfrow=c(1,1))

}
