% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{oi_async}
\alias{oi_async}
\title{Syntactic Sugar for Asynchronous Optimization Instance Construction}
\usage{
oi_async(
  objective,
  search_space = NULL,
  terminator,
  check_values = FALSE,
  callbacks = NULL,
  rush = NULL
)
}
\arguments{
\item{objective}{(\link{Objective})\cr
Objective function.}

\item{search_space}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies the search space for the \link{Optimizer}. The \link[paradox:ParamSet]{paradox::ParamSet}
describes either a subset of the \code{domain} of the \link{Objective} or it describes
a set of parameters together with a \code{trafo} function that transforms values
from the search space to values of the domain. Depending on the context, this
value defaults to the domain of the objective.}

\item{terminator}{\link{Terminator}\cr
Termination criterion.}

\item{check_values}{(\code{logical(1)})\cr
Should points before the evaluation and the results be checked for validity?}

\item{callbacks}{(list of \link[mlr3misc:Callback]{mlr3misc::Callback})\cr
List of callbacks.}

\item{rush}{(\code{Rush})\cr
If a rush instance is supplied, the tuning runs without batches.}
}
\description{
Function to construct an \link{OptimInstanceAsyncSingleCrit} and \link{OptimInstanceAsyncMultiCrit}.
}
\examples{
# example only runs if a Redis server is available
if (mlr3misc::require_namespaces(c("rush", "redux", "mirai"), quietly = TRUE) &&
  redux::redis_available()) {
# define the objective function
fun = function(xs) {
  list(y = - (xs[[1]] - 2)^2 - (xs[[2]] + 3)^2 + 10)
}

# set domain
domain = ps(
  x1 = p_dbl(-10, 10),
  x2 = p_dbl(-5, 5)
)

# set codomain
codomain = ps(
  y = p_dbl(tags = "maximize")
)

# create objective
objective = ObjectiveRFun$new(
  fun = fun,
  domain = domain,
  codomain = codomain,
  properties = "deterministic"
)

# start workers
rush::rush_plan(worker_type = "remote")
mirai::daemons(1)

# initialize instance
instance = oi_async(
  objective = objective,
  terminator = trm("evals", n_evals = 20)
)
}
}
