% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_RunModelsLoop.R
\name{bm_RunModelsLoop}
\alias{bm_RunModelsLoop}
\alias{bm_RunModel}
\title{Loop to compute all single species distribution models}
\usage{
bm_RunModelsLoop(
  bm.format,
  weights,
  calib.lines,
  modeling.id,
  models,
  models.pa,
  bm.options,
  metric.eval,
  var.import,
  scale.models = TRUE,
  nb.cpu = 1,
  seed.val = NULL,
  do.progress = TRUE
)

bm_RunModel(
  model,
  run.name,
  dir.name = ".",
  modeling.id = "",
  bm.options,
  Data,
  weights.vec,
  calib.lines.vec,
  eval.data = NULL,
  metric.eval = c("ROC", "TSS", "KAPPA"),
  var.import = 0,
  scale.models = TRUE,
  nb.cpu = 1,
  seed.val = NULL,
  do.progress = TRUE
)
}
\arguments{
\item{bm.format}{a \code{\link{BIOMOD.formated.data}} or \code{\link{BIOMOD.formated.data.PA}} 
object returned by the \code{\link{BIOMOD_FormatingData}} function}

\item{weights}{a \code{matrix} containing observation weights for each pseudo-absence (or 
\code{allData}) dataset}

\item{calib.lines}{a \code{matrix} containing calibration / validation lines for each 
pseudo-absence (or \code{allData}) x repetition (or \code{allRun}) combination that can be 
obtained with the \code{\link{bm_CrossValidation}} function}

\item{modeling.id}{a \code{character} corresponding to the name (ID) of the simulation set 
(\emph{a random number by default})}

\item{models}{a \code{vector} containing model names to be computed, must be among 
\code{ANN}, \code{CTA}, \code{FDA}, \code{GAM}, \code{GBM}, \code{GLM}, \code{MARS}, 
\code{MAXENT}, \code{MAXNET}, \code{RF}, \code{RFd}, \code{SRE}, \code{XGBOOST}}

\item{models.pa}{(\emph{optional, default} \code{NULL}) \cr 
A \code{list} containing for each model a \code{vector} defining which pseudo-absence datasets 
are to be used, must be among \code{colnames(bm.format@PA.table)}}

\item{bm.options}{a \code{\link{BIOMOD.models.options}} object returned by the
\code{\link{bm_ModelingOptions}} function}

\item{metric.eval}{a \code{vector} containing evaluation metric names to be used, must 
be among \code{POD}, \code{FAR}, \code{POFD}, \code{SR}, \code{ACCURACY}, \code{BIAS}, 
\code{ROC}, \code{TSS}, \code{KAPPA}, \code{OR}, \code{ORSS}, \code{CSI}, \code{ETS}, 
\code{BOYCE}, \code{MPA}}

\item{var.import}{(\emph{optional, default} \code{NULL}) \cr 
An \code{integer} corresponding to the number of permutations to be done for each variable to 
estimate variable importance}

\item{scale.models}{(\emph{optional, default} \code{FALSE}) \cr 
A \code{logical} value defining whether all models predictions should be scaled with a 
binomial GLM or not}

\item{nb.cpu}{(\emph{optional, default} \code{1}) \cr 
An \code{integer} value corresponding to the number of computing resources to be used to 
parallelize the single models computation}

\item{seed.val}{(\emph{optional, default} \code{NULL}) \cr 
An \code{integer} value corresponding to the new seed value to be set}

\item{do.progress}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the progress bar is to be rendered or not}

\item{model}{a \code{character} corresponding to the model name to be computed, must be either 
\code{ANN}, \code{CTA}, \code{FDA}, \code{GAM}, \code{GBM}, \code{GLM}, \code{MARS}, 
\code{MAXENT}, \code{MAXNET}, \code{RF}, \code{RFd}, \code{SRE}, \code{XGBOOST}}

\item{run.name}{a \code{character} corresponding to the model to be run (sp.name + pa.id + 
run.id)}

\item{dir.name}{(\emph{optional, default} \code{.}) \cr
A \code{character} corresponding to the modeling folder}

\item{Data}{a \code{data.frame} containing observations, coordinates and environmental 
variables that can be obtained with the \code{get_species_data} function}

\item{weights.vec}{a \code{vector} containing observation weights the concerned pseudo-absence 
(or \code{allData}) dataset}

\item{calib.lines.vec}{a \code{vector} containing calibration / validation lines for the 
concerned pseudo-absence (or \code{allData}) x repetition (or \code{allRun}) combination}

\item{eval.data}{(\emph{optional, default} \code{NULL}) \cr
A \code{data.frame} containing validation observations, coordinates and environmental 
variables that can be obtained with the \code{get_eval_data} function}
}
\value{
A \code{list} containing for each model a \code{list} containing the following elements :
\itemize{
  \item \code{model} : the name of correctly computed model
  \item \code{calib.failure} : the name of incorrectly computed model
  \item \code{pred} : the prediction outputs for calibration data
  \item \code{pred.eval} : the prediction outputs for evaluation data
  \item \code{evaluation} : the evaluation outputs returned by the 
  \code{\link{bm_FindOptimStat}} function
  \item \code{var.import} : the mean of variables importance returned by the 
  \code{\link{bm_VariablesImportance}} function
}
}
\description{
This internal \pkg{biomod2} function allows the user to compute all single 
species distribution models (asked by the \code{\link{BIOMOD_Modeling}} function).
}
\seealso{
\code{\link[rpart]{rpart}}, \code{\link[rpart]{prune}}, \code{\link[gbm]{gbm}}, 
\code{\link[nnet]{nnet}}, \code{\link[earth]{earth}}, 
\code{\link[mda]{fda}}, \code{\link[mda]{mars}}, \code{\link[maxnet]{maxnet}}, 
\code{\link[randomForest]{randomForest}}, \code{\link[xgboost]{xgboost}}, 
\code{\link{bm_ModelingOptions}}, \code{\link{BIOMOD_Modeling}}, 
\code{\link{bm_MakeFormula}}, \code{\link{bm_SampleFactorLevels}}, 
\code{\link{bm_FindOptimStat}}, \code{\link{bm_VariablesImportance}}

Other Secondary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_ModelingOptions}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_Tuning}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Damien Georges
}
\concept{Secondary functions}
\keyword{ANN}
\keyword{CTA}
\keyword{FDA}
\keyword{GAM}
\keyword{GBM}
\keyword{GLM}
\keyword{MARS}
\keyword{MAXENT}
\keyword{RF}
\keyword{SRE}
\keyword{XGBOOST}
\keyword{formula}
\keyword{models}
\keyword{options}
